/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.support.v4.app.NotificationManagerCompat;
import android.util.Log;

public class SoftwareInformation {
    private static String appVersion = null;
    private static String appName = null;
    private static Integer appIconResourceId = null;
    private static NotificationManagerCompat notificationManagerCompat = null;

    private SoftwareInformation() {
    }

    public static String getAppVersion(Context context) {
        if (appVersion != null) {
            return appVersion;
        }
        try {
            appVersion = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.d((String)"MobileMessaging", (String)Log.getStackTraceString((Throwable)e));
        }
        return appVersion;
    }

    public static String getAppName(Context context) {
        if (appName != null) {
            return appName;
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
            appName = packageManager.getApplicationLabel(applicationInfo).toString();
        }
        catch (Exception e) {
            Log.d((String)"MobileMessaging", (String)Log.getStackTraceString((Throwable)e));
        }
        return appName;
    }

    public static int getAppIconResourceId(Context context) {
        if (appIconResourceId != null) {
            return appIconResourceId;
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
            appIconResourceId = applicationInfo.icon;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return appIconResourceId != null ? appIconResourceId : 0;
    }

    public static String getLibraryVersion() {
        return "1.3.24";
    }

    public static boolean isDebuggableApplicationBuild(Context context) {
        return (context.getApplicationInfo().flags & 2) != 0;
    }

    public static boolean areNotificationsEnabled(Context context) {
        if (notificationManagerCompat == null) {
            notificationManagerCompat = NotificationManagerCompat.from((Context)context);
        }
        return notificationManagerCompat.areNotificationsEnabled();
    }
}

