/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.os.Bundle;
import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.infobip.mobile.messaging.dal.bundle.BundleMessageMapper;
import org.infobip.mobile.messaging.geo.Geo;
import org.json.JSONObject;

public class Message
implements Comparable<Message> {
    private String messageId;
    private String title;
    private String body;
    private String sound;
    private boolean vibrate;
    private String icon;
    private boolean silent;
    private String category;
    private String from;
    private long receivedTimestamp;
    private long seenTimestamp;
    private JSONObject internalData;
    private JSONObject customPayload;
    private Geo geo;
    private String destination;
    private Status status;
    private String statusMessage;

    public static Message createFrom(Bundle bundle) {
        return BundleMessageMapper.fromBundle(bundle);
    }

    public static List<Message> createFrom(ArrayList<Bundle> bundles) {
        return BundleMessageMapper.fromBundles(bundles);
    }

    public Message(String messageId, String title, String body, String sound, boolean vibrate, String icon, boolean silent, String category, String from, long receivedTimestamp, long seenTimestamp, JSONObject internalData, JSONObject customPayload, Geo geo, String destination, Status status, String statusMessage) {
        this.messageId = messageId;
        this.title = title;
        this.body = body;
        this.sound = sound;
        this.vibrate = vibrate;
        this.icon = icon;
        this.silent = silent;
        this.category = category;
        this.from = from;
        this.receivedTimestamp = receivedTimestamp;
        this.seenTimestamp = seenTimestamp;
        this.internalData = internalData;
        this.customPayload = customPayload;
        this.geo = geo;
        this.destination = destination;
        this.status = status;
        this.statusMessage = statusMessage;
    }

    public Message() {
        this.messageId = UUID.randomUUID().toString();
        this.receivedTimestamp = System.currentTimeMillis();
        this.status = Status.UNKNOWN;
    }

    @Override
    public int compareTo(@NonNull Message another) {
        return (int)Math.signum(another.receivedTimestamp - this.receivedTimestamp);
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getSound() {
        return this.sound;
    }

    public void setSound(String sound) {
        this.sound = sound;
    }

    public boolean isDefaultSound() {
        return "default".equals(this.sound);
    }

    public boolean isVibrate() {
        return this.vibrate;
    }

    public void setVibrate(boolean vibrate) {
        this.vibrate = vibrate;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public long getReceivedTimestamp() {
        return this.receivedTimestamp;
    }

    public void setReceivedTimestamp(long receivedTimestamp) {
        this.receivedTimestamp = receivedTimestamp;
    }

    public long getSeenTimestamp() {
        return this.seenTimestamp;
    }

    public void setSeenTimestamp(long seenTimestamp) {
        this.seenTimestamp = seenTimestamp;
    }

    public JSONObject getInternalData() {
        return this.internalData;
    }

    public void setInternalData(JSONObject internalData) {
        this.internalData = internalData;
    }

    public JSONObject getCustomPayload() {
        return this.customPayload;
    }

    public void setCustomPayload(JSONObject customPayload) {
        this.customPayload = customPayload;
    }

    public Geo getGeo() {
        return this.geo;
    }

    public void setGeo(Geo geo) {
        this.geo = geo;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public static enum Status {
        SUCCESS,
        ERROR,
        UNKNOWN;

    }
}

