/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.dal.sqlite;

import android.content.ContentValues;
import android.database.Cursor;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;
import org.infobip.mobile.messaging.dal.sqlite.DatabaseContract;
import org.infobip.mobile.messaging.geo.Geo;
import org.json.JSONObject;

public class SqliteMessage
extends Message
implements DatabaseContract.DatabaseObject {
    public SqliteMessage() {
        super(null, null, null, null, true, null, false, null, null, 0L, 0L, null, null, null, null, Message.Status.UNKNOWN, null);
    }

    public SqliteMessage(Message m) {
        super(m.getMessageId(), m.getTitle(), m.getBody(), m.getSound(), m.isVibrate(), m.getIcon(), m.isSilent(), m.getCategory(), m.getFrom(), m.getReceivedTimestamp(), m.getSeenTimestamp(), m.getInternalData(), m.getCustomPayload(), m.getGeo(), m.getDestination(), m.getStatus(), m.getStatusMessage());
    }

    public static ContentValues save(Message message) {
        return new SqliteMessage(message).getContentValues();
    }

    public static Message load(Cursor cursor) throws Exception {
        SqliteMessage sqliteMessageMapper = new SqliteMessage();
        sqliteMessageMapper.fillFromCursor(cursor);
        return sqliteMessageMapper;
    }

    public static String getTable() {
        return new SqliteMessage().getTableName();
    }

    @Override
    public void fillFromCursor(Cursor cursor) throws Exception {
        this.setMessageId(cursor.getString(cursor.getColumnIndexOrThrow("id")));
        this.setTitle(cursor.getString(cursor.getColumnIndexOrThrow("title")));
        this.setBody(cursor.getString(cursor.getColumnIndexOrThrow("body")));
        this.setSound(cursor.getString(cursor.getColumnIndexOrThrow("sound")));
        this.setVibrate(cursor.getInt(cursor.getColumnIndexOrThrow("vibrate")) != 0);
        this.setIcon(cursor.getString(cursor.getColumnIndexOrThrow("icon")));
        this.setSilent(cursor.getShort(cursor.getColumnIndexOrThrow("silent")) != 0);
        this.setCategory(cursor.getString(cursor.getColumnIndexOrThrow("category")));
        this.setFrom(cursor.getString(cursor.getColumnIndexOrThrow("_from")));
        this.setReceivedTimestamp(cursor.getLong(cursor.getColumnIndexOrThrow("received_timestamp")));
        this.setSeenTimestamp(cursor.getLong(cursor.getColumnIndexOrThrow("seen_timestamp")));
        String json = cursor.getString(cursor.getColumnIndexOrThrow("internal_data"));
        this.setInternalData(json == null ? null : new JSONObject(json));
        this.setGeo((Geo)new JsonSerializer().deserialize(json, Geo.class));
        json = cursor.getString(cursor.getColumnIndexOrThrow("custom_payload"));
        this.setCustomPayload(json == null ? null : new JSONObject(json));
        this.setDestination(cursor.getString(cursor.getColumnIndex("destination")));
        String statusName = cursor.getString(cursor.getColumnIndex("status"));
        this.setStatus(statusName != null ? Message.Status.valueOf(statusName) : null);
        this.setStatusMessage(cursor.getString(cursor.getColumnIndex("status_message")));
    }

    @Override
    public ContentValues getContentValues() {
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", this.getMessageId());
        contentValues.put("title", this.getTitle());
        contentValues.put("body", this.getBody());
        contentValues.put("sound", this.getSound());
        contentValues.put("vibrate", Integer.valueOf(this.isVibrate() ? 1 : 0));
        contentValues.put("icon", this.getIcon());
        contentValues.put("silent", Integer.valueOf(this.isSilent() ? 1 : 0));
        contentValues.put("category", this.getCategory());
        contentValues.put("_from", this.getFrom());
        contentValues.put("received_timestamp", Long.valueOf(this.getReceivedTimestamp()));
        contentValues.put("seen_timestamp", Long.valueOf(this.getSeenTimestamp()));
        contentValues.put("internal_data", this.getInternalData() != null ? this.getInternalData().toString() : null);
        contentValues.put("custom_payload", this.getCustomPayload() != null ? this.getCustomPayload().toString() : null);
        contentValues.put("destination", this.getDestination());
        contentValues.put("status", this.getStatus() != null ? this.getStatus().name() : null);
        contentValues.put("status_message", this.getStatusMessage());
        return contentValues;
    }

    @Override
    public String getTableName() {
        return "messages";
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return "id";
    }
}

