/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.geo;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.infobip.mobile.messaging.MobileMessagingLogger;
import org.infobip.mobile.messaging.geo.Area;
import org.infobip.mobile.messaging.geo.DeliveryTime;
import org.infobip.mobile.messaging.geo.GeoEvent;
import org.infobip.mobile.messaging.util.DateTimeUtil;
import org.infobip.mobile.messaging.util.ISO8601DateParseException;

public class Geo
implements Parcelable {
    @SerializedName(value="triggeringLatitude")
    private Double triggeringLatitude;
    @SerializedName(value="triggeringLongitude")
    private Double triggeringLongitude;
    @SerializedName(value="geo")
    private List<Area> areasList = new ArrayList<Area>();
    @SerializedName(value="deliveryTime")
    private DeliveryTime deliveryTime;
    @SerializedName(value="event")
    private List<GeoEvent> events = new ArrayList<GeoEvent>();
    @SerializedName(value="expiryTime")
    private String expiryTime;
    @SerializedName(value="startTime")
    private String startTime;
    @SerializedName(value="campaignId")
    private String campaignId;
    public static final Parcelable.Creator<Geo> CREATOR = new Parcelable.Creator<Geo>(){

        public Geo createFromParcel(Parcel in) {
            return new Geo(in);
        }

        public Geo[] newArray(int size) {
            return new Geo[size];
        }
    };

    protected Geo(Double triggeringLatitude, Double triggeringLongitude, List<Area> areasList) {
        this.triggeringLatitude = triggeringLatitude;
        this.triggeringLongitude = triggeringLongitude;
        this.areasList = areasList;
    }

    protected Geo(Parcel in) {
        this.triggeringLatitude = in.readDouble();
        this.triggeringLongitude = in.readDouble();
        in.readTypedList(this.areasList, Area.CREATOR);
        this.deliveryTime = (DeliveryTime)in.readParcelable(DeliveryTime.class.getClassLoader());
        in.readTypedList(this.events, GeoEvent.CREATOR);
        this.expiryTime = in.readString();
        this.startTime = in.readString();
        this.campaignId = in.readString();
    }

    public Geo(Double triggeringLatitude, Double triggeringLongitude, List<Area> areasList, DeliveryTime deliveryTime, List<GeoEvent> events, String expiryTime, String startTime, String campaignId) {
        this.triggeringLatitude = triggeringLatitude;
        this.triggeringLongitude = triggeringLongitude;
        this.areasList = areasList;
        this.deliveryTime = deliveryTime;
        this.events = events;
        this.expiryTime = expiryTime;
        this.startTime = startTime;
        this.campaignId = campaignId;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeDouble(this.triggeringLatitude.doubleValue());
        parcel.writeDouble(this.triggeringLongitude.doubleValue());
        parcel.writeTypedList(this.areasList);
        parcel.writeParcelable((Parcelable)this.deliveryTime, i);
        parcel.writeTypedList(this.events);
        parcel.writeString(this.expiryTime);
        parcel.writeString(this.startTime);
        parcel.writeString(this.campaignId);
    }

    public static Geo createFrom(Bundle bundle) {
        return (Geo)bundle.getParcelable("org.infobip.mobile.messaging.geofence.areas");
    }

    public Double getTriggeringLatitude() {
        return this.triggeringLatitude;
    }

    public Double getTriggeringLongitude() {
        return this.triggeringLongitude;
    }

    public List<Area> getAreasList() {
        return this.areasList;
    }

    protected List<GeoEvent> getEvents() {
        return this.events;
    }

    protected DeliveryTime getDeliveryTime() {
        return this.deliveryTime;
    }

    protected Date getExpiryDate() {
        try {
            return DateTimeUtil.ISO8601DateFromString(this.expiryTime);
        }
        catch (ISO8601DateParseException e) {
            MobileMessagingLogger.e("Cannot parse expiry date: " + e.getMessage());
            MobileMessagingLogger.d(Log.getStackTraceString((Throwable)e));
            return null;
        }
    }

    protected Date getStartDate() {
        try {
            return DateTimeUtil.ISO8601DateFromString(this.startTime);
        }
        catch (ISO8601DateParseException e) {
            MobileMessagingLogger.e("Cannot parse start date: " + e.getMessage());
            MobileMessagingLogger.d(Log.getStackTraceString((Throwable)e));
            return null;
        }
    }

    protected String getCampaignId() {
        return this.campaignId;
    }

    boolean isEligibleForMonitoring() {
        Date now = new Date();
        return (this.getStartDate() == null || this.getStartDate().before(now)) && !this.isExpired();
    }

    boolean isExpired() {
        Date now = new Date();
        Date expiryDate = this.getExpiryDate();
        return expiryDate != null && expiryDate.before(now);
    }
}

