/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.geo;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationServices;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingLogger;
import org.infobip.mobile.messaging.api.support.Tuple;
import org.infobip.mobile.messaging.gcm.PlayServicesSupport;
import org.infobip.mobile.messaging.geo.Area;
import org.infobip.mobile.messaging.geo.ConfigurationException;
import org.infobip.mobile.messaging.geo.Geo;
import org.infobip.mobile.messaging.geo.GeofenceTransitionsIntentService;
import org.infobip.mobile.messaging.geo.GeofencingConsistencyReceiver;
import org.infobip.mobile.messaging.storage.MessageStore;

public class Geofencing
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    private static String TAG = "Geofencing";
    private static Context context;
    private static Geofencing instance;
    private GoogleApiClient googleApiClient;
    private List<Geofence> geofences;
    private PendingIntent geofencePendingIntent;
    private MessageStore messageStore;

    private Geofencing(Context context) {
        this.checkRequiredService(context, GeofenceTransitionsIntentService.class);
        Geofencing.context = context;
        this.geofences = new ArrayList<Geofence>();
        this.messageStore = MobileMessagingCore.getInstance(context).getMessageStoreForGeo();
        this.googleApiClient = new GoogleApiClient.Builder(context).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
    }

    public static Geofencing getInstance(Context context) {
        if (instance != null) {
            return instance;
        }
        instance = new Geofencing(context);
        return instance;
    }

    public static void scheduleRefresh(Context context) {
        Geofencing.scheduleRefresh(context, new Date());
    }

    public static void scheduleRefresh(Context context, Date when) {
        MobileMessagingLogger.i(TAG, "Next refresh in: " + when);
        if (when == null) {
            return;
        }
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        Intent intent = new Intent(context, GeofencingConsistencyReceiver.class);
        intent.setAction("org.infobip.mobile.messaging.geo.intent.SCHEDULED_GEO_REFRESH");
        alarmManager.set(0, when.getTime(), PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0));
    }

    static Tuple<List<Geofence>, Date> calculateGeofencesToMonitorAndNextCheckDate(MessageStore messageStore) {
        Date nextCheckDate = null;
        HashMap<String, Geofence> geofences = new HashMap<String, Geofence>();
        HashMap<String, Date> expiryDates = new HashMap<String, Date>();
        List<Message> messages = messageStore.findAll(context);
        for (Message message : messages) {
            List<String> finishedCampaignIds;
            Geo geo = message.getGeo();
            if (geo == null || geo.getAreasList() == null || geo.getAreasList().isEmpty() || (finishedCampaignIds = Arrays.asList(MobileMessagingCore.getInstance(context).getFinishedCampaignIds())).contains(geo.getCampaignId())) continue;
            if (geo.isEligibleForMonitoring()) {
                List<Area> geoAreasList = message.getGeo().getAreasList();
                for (Area area : geoAreasList) {
                    Date expiry;
                    if (!area.isValid() || (expiry = (Date)expiryDates.get(area.getId())) != null && expiry.after(geo.getExpiryDate())) continue;
                    expiryDates.put(area.getId(), geo.getExpiryDate());
                    geofences.put(area.getId(), area.toGeofence(geo.getExpiryDate()));
                }
            }
            nextCheckDate = Geofencing.calculateNextCheckDateForGeo(geo, nextCheckDate);
        }
        ArrayList geofenceList = new ArrayList(geofences.values());
        return new Tuple(geofenceList, nextCheckDate);
    }

    private static Date calculateNextCheckDateForGeo(Geo geo, Date oldCheckDate) {
        Date now = new Date();
        Date expiryDate = geo.getExpiryDate();
        if (expiryDate != null && expiryDate.before(now)) {
            return oldCheckDate;
        }
        Date startDate = geo.getStartDate();
        if (startDate == null || startDate.before(now)) {
            return oldCheckDate;
        }
        if (oldCheckDate != null && oldCheckDate.before(startDate)) {
            return oldCheckDate;
        }
        return startDate;
    }

    public void startGeoMonitoring() {
        if (!PlayServicesSupport.isPlayServicesAvailable(context) || !MobileMessagingCore.isGeofencingActivated(context)) {
            return;
        }
        if (!this.checkRequiredPermissions()) {
            return;
        }
        Tuple<List<Geofence>, Date> tuple = Geofencing.calculateGeofencesToMonitorAndNextCheckDate(this.messageStore);
        Geofencing.scheduleRefresh(context, (Date)tuple.getRight());
        this.geofences = (List)tuple.getLeft();
        if (this.geofences.isEmpty()) {
            return;
        }
        if (!this.googleApiClient.isConnected()) {
            this.googleApiClient.connect();
            return;
        }
        LocationServices.GeofencingApi.addGeofences(this.googleApiClient, this.geofencingRequest(), this.geofencePendingIntent()).setResultCallback((ResultCallback)new ResultCallback<Status>(){

            public void onResult(@NonNull Status status) {
                Geofencing.this.logGeofenceStatus(status, true);
            }
        });
    }

    public void stopGeoMonitoring() {
        if (!this.checkRequiredPermissions()) {
            return;
        }
        if (!this.googleApiClient.isConnected()) {
            this.googleApiClient.connect();
            return;
        }
        LocationServices.GeofencingApi.removeGeofences(this.googleApiClient, this.geofencePendingIntent()).setResultCallback((ResultCallback)new ResultCallback<Status>(){

            public void onResult(@NonNull Status status) {
                Geofencing.this.logGeofenceStatus(status, false);
            }
        });
    }

    public void removeGeofencesFromMonitoring(List<String> geofenceRequestIds) {
        if (!this.checkRequiredPermissions()) {
            return;
        }
        if (!this.googleApiClient.isConnected()) {
            this.googleApiClient.connect();
            return;
        }
        LocationServices.GeofencingApi.removeGeofences(this.googleApiClient, geofenceRequestIds);
    }

    private boolean checkRequiredPermissions() {
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
            MobileMessagingLogger.e("Unable to initialize geofencing", new ConfigurationException(ConfigurationException.Reason.MISSING_REQUIRED_PERMISSION, "android.permission.ACCESS_FINE_LOCATION"));
            return false;
        }
        return true;
    }

    private void checkRequiredService(Context context, Class serviceClass) {
        String serviceName = serviceClass.getCanonicalName();
        ComponentName componentName = new ComponentName(context.getPackageName(), serviceName);
        try {
            context.getPackageManager().getServiceInfo(componentName, 128);
        }
        catch (PackageManager.NameNotFoundException localNameNotFoundException) {
            throw new ConfigurationException(ConfigurationException.Reason.MISSING_REQUIRED_SERVICE, serviceName);
        }
    }

    private void logGeofenceStatus(@NonNull Status status, boolean activated) {
        if (status.isSuccess()) {
            MobileMessagingLogger.d(TAG, "Geofencing monitoring " + (activated ? "" : "de-") + "activated successfully");
        } else {
            MobileMessagingLogger.e(TAG, "Geofencing monitoring " + (activated ? "" : "de-") + "activation failed", new Throwable(status.getStatusMessage()));
        }
    }

    private GeofencingRequest geofencingRequest() {
        GeofencingRequest.Builder builder = new GeofencingRequest.Builder();
        builder.setInitialTrigger(1);
        builder.addGeofences(this.geofences);
        return builder.build();
    }

    private PendingIntent geofencePendingIntent() {
        if (this.geofencePendingIntent == null) {
            Intent intent = new Intent(context, GeofenceTransitionsIntentService.class);
            this.geofencePendingIntent = PendingIntent.getService((Context)context, (int)0, (Intent)intent, (int)0x8000000);
        }
        return this.geofencePendingIntent;
    }

    public void onConnected(@Nullable Bundle bundle) {
        MobileMessagingLogger.d(TAG, "GoogleApiClient connected");
        this.startGeoMonitoring();
    }

    public void onConnectionSuspended(int i) {
    }

    public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        MobileMessagingLogger.e(TAG, connectionResult.getErrorMessage(), new ConfigurationException(ConfigurationException.Reason.CHECK_LOCATION_SETTINGS));
    }
}

