/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.geo;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.location.LocationManager;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingLogger;

public class GeofencingConsistencyReceiver
extends BroadcastReceiver {
    public static final String NETWORK_PROVIDER_ENABLED_ACTION = "org.infobip.mobile.messaging.geo.intent.NETWORK_PROVIDER_ENABLED";
    public static final String SCHEDULED_GEO_REFRESH_ACTION = "org.infobip.mobile.messaging.geo.intent.SCHEDULED_GEO_REFRESH";

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if (action != null) {
            MobileMessagingLogger.i(String.format("[%s]", action));
            switch (action) {
                case "android.location.PROVIDERS_CHANGED": {
                    LocationManager lm = (LocationManager)context.getSystemService("location");
                    if (!lm.isProviderEnabled("network")) break;
                    AlarmManager mgr = (AlarmManager)context.getSystemService("alarm");
                    Intent locationSendingIntent = new Intent(context, GeofencingConsistencyReceiver.class);
                    locationSendingIntent.setAction(NETWORK_PROVIDER_ENABLED_ACTION);
                    PendingIntent pi = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)locationSendingIntent, (int)0);
                    mgr.set(1, System.currentTimeMillis() + 15000L, pi);
                    break;
                }
                case "org.infobip.mobile.messaging.geo.intent.NETWORK_PROVIDER_ENABLED": 
                case "org.infobip.mobile.messaging.geo.intent.SCHEDULED_GEO_REFRESH": {
                    MobileMessagingCore.getInstance(context).startGeoMonitoringIfNecessary();
                }
            }
        }
    }
}

