/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.data;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.support.v4.content.LocalBroadcastManager;
import java.io.Serializable;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingLogger;
import org.infobip.mobile.messaging.UserData;
import org.infobip.mobile.messaging.api.data.UserDataReport;
import org.infobip.mobile.messaging.mobile.InternalSdkError;
import org.infobip.mobile.messaging.mobile.MobileApiResourceProvider;
import org.infobip.mobile.messaging.mobile.MobileMessagingError;
import org.infobip.mobile.messaging.mobile.data.SyncUserDataResult;
import org.infobip.mobile.messaging.mobile.data.UserDataMapper;
import org.infobip.mobile.messaging.util.StringUtils;

@TargetApi(value=14)
class SyncUserDataTask
extends AsyncTask<Void, Void, SyncUserDataResult> {
    private final Context context;

    SyncUserDataTask(Context context) {
        this.context = context;
    }

    protected SyncUserDataResult doInBackground(Void ... notUsed) {
        MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance(this.context);
        String deviceApplicationInstanceId = mobileMessagingCore.getDeviceApplicationInstanceId();
        if (StringUtils.isBlank(deviceApplicationInstanceId)) {
            MobileMessagingLogger.e(InternalSdkError.NO_VALID_REGISTRATION.get());
            return new SyncUserDataResult(InternalSdkError.NO_VALID_REGISTRATION.getException());
        }
        UserData userData = mobileMessagingCore.getUnreportedUserData();
        if (userData == null) {
            userData = new UserData();
        }
        try {
            UserDataReport request = UserDataMapper.toUserDataReport(userData.getPredefinedUserData(), userData.getCustomUserData());
            UserDataReport response = MobileApiResourceProvider.INSTANCE.getMobileApiData(this.context).reportUserData(deviceApplicationInstanceId, userData.getExternalUserId(), request);
            return new SyncUserDataResult(response.getPredefinedUserData(), response.getCustomUserData());
        }
        catch (Exception e) {
            mobileMessagingCore.setLastHttpException(e);
            MobileMessagingLogger.e("Error synchronizing user data!", e);
            this.cancel(true);
            Intent userDataSyncError = new Intent(Event.API_COMMUNICATION_ERROR.getKey());
            userDataSyncError.putExtra("org.infobip.mobile.messaging.exception", (Serializable)MobileMessagingError.createFrom(e));
            this.context.sendBroadcast(userDataSyncError);
            LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(userDataSyncError);
            return new SyncUserDataResult(e);
        }
    }
}

