/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.data;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.support.v4.content.LocalBroadcastManager;
import java.io.Serializable;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingLogger;
import org.infobip.mobile.messaging.SystemData;
import org.infobip.mobile.messaging.api.data.SystemDataReport;
import org.infobip.mobile.messaging.mobile.InternalSdkError;
import org.infobip.mobile.messaging.mobile.MobileApiResourceProvider;
import org.infobip.mobile.messaging.mobile.MobileMessagingError;
import org.infobip.mobile.messaging.mobile.data.SystemDataReportResult;
import org.infobip.mobile.messaging.util.StringUtils;

class SystemDataReportTask
extends AsyncTask<SystemDataReport, Void, SystemDataReportResult> {
    private final Context context;

    SystemDataReportTask(Context context) {
        this.context = context;
    }

    protected SystemDataReportResult doInBackground(SystemDataReport ... params) {
        if (params.length < 1) {
            MobileMessagingLogger.e(InternalSdkError.ERROR_EMPTY_SYSTEM_DATA.get());
            return new SystemDataReportResult(InternalSdkError.ERROR_EMPTY_SYSTEM_DATA.getException());
        }
        SystemDataReport report = params[0];
        SystemData data = new SystemData(report.getSdkVersion(), report.getOsVersion(), report.getDeviceManufacturer(), report.getDeviceModel(), report.getApplicationVersion(), report.getGeofencing(), report.getNotificationsEnabled());
        MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance(this.context);
        String deviceApplicationInstanceId = mobileMessagingCore.getDeviceApplicationInstanceId();
        if (StringUtils.isBlank(deviceApplicationInstanceId)) {
            MobileMessagingLogger.w("Can't report system data without valid registration");
            return new SystemDataReportResult(data, true);
        }
        try {
            MobileApiResourceProvider.INSTANCE.getMobileApiData(this.context).reportSystemData(deviceApplicationInstanceId, report);
            return new SystemDataReportResult(data);
        }
        catch (Exception e) {
            mobileMessagingCore.setLastHttpException(e);
            MobileMessagingLogger.e("Error reporting system data!", e);
            this.cancel(true);
            Intent userDataSyncError = new Intent(Event.API_COMMUNICATION_ERROR.getKey());
            userDataSyncError.putExtra("org.infobip.mobile.messaging.exception", (Serializable)MobileMessagingError.createFrom(e));
            this.context.sendBroadcast(userDataSyncError);
            LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(userDataSyncError);
            return new SystemDataReportResult(e);
        }
    }
}

