/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.data;

import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import java.io.Serializable;
import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingLogger;
import org.infobip.mobile.messaging.SystemData;
import org.infobip.mobile.messaging.api.data.SystemDataReport;
import org.infobip.mobile.messaging.mobile.MobileMessagingError;
import org.infobip.mobile.messaging.mobile.data.SystemDataReportResult;
import org.infobip.mobile.messaging.mobile.data.SystemDataReportTask;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.stats.MobileMessagingStatsError;

public class SystemDataReporter {
    public void report(final Context context, final MobileMessagingStats stats, Executor executor) {
        SystemData data = MobileMessagingCore.getInstance(context).getUnreportedSystemData();
        if (data == null) {
            return;
        }
        SystemDataReport report = new SystemDataReport(data.getSdkVersion(), data.getOsVersion(), data.getDeviceManufacturer(), data.getDeviceModel(), data.getApplicationVersion(), Boolean.valueOf(data.isGeofencing()), Boolean.valueOf(data.areNotificationsEnabled()));
        new SystemDataReportTask(context){

            protected void onPostExecute(SystemDataReportResult result) {
                if (result.hasError()) {
                    MobileMessagingLogger.e("MobileMessaging API returned error (system data)!");
                    stats.reportError(MobileMessagingStatsError.SYSTEM_DATA_REPORT_ERROR);
                    Intent intent = new Intent(Event.API_COMMUNICATION_ERROR.getKey());
                    intent.putExtra("org.infobip.mobile.messaging.exception", (Serializable)MobileMessagingError.createFrom(result.getError()));
                    context.sendBroadcast(intent);
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
                    return;
                }
                if (result.isPostponed()) {
                    MobileMessagingLogger.w("System data report is saved and will be sent at a later time");
                    return;
                }
                MobileMessagingCore.getInstance(context).setSystemDataReported();
                Intent dataReported = new Intent(Event.SYSTEM_DATA_REPORTED.getKey());
                dataReported.putExtra("org.infobip.mobile.messaging.systemdata", result.getData().toString());
                context.sendBroadcast(dataReported);
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(dataReported);
            }

            protected void onCancelled() {
                MobileMessagingLogger.e("Error reporting user data!");
                stats.reportError(MobileMessagingStatsError.SYSTEM_DATA_REPORT_ERROR);
            }
        }.executeOnExecutor(executor, new SystemDataReport[]{report});
    }
}

