/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.messages;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingLogger;
import org.infobip.mobile.messaging.dal.bundle.BundleMessageMapper;
import org.infobip.mobile.messaging.gcm.MobileMessageHandler;
import org.infobip.mobile.messaging.mobile.messages.SyncMessagesResult;
import org.infobip.mobile.messaging.mobile.messages.SyncMessagesTask;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.stats.MobileMessagingStatsError;

public class MessagesSynchronizer {
    private static final int DEFAULT_MAX_RETRY_COUNT = 3;
    private Handler handler = new Handler(Looper.getMainLooper());

    public void synchronize(Context context, MobileMessagingStats stats, Executor executor) {
        this.scheduleSyncMessagesTask(context, stats, executor, 0);
    }

    private void startSyncMessagesTask(final Context context, final MobileMessagingStats stats, final Executor executor, final int numOfAttemptsDone) {
        new SyncMessagesTask(context){

            protected void onPostExecute(SyncMessagesResult syncMessagesResult) {
                if (syncMessagesResult.hasError()) {
                    MobileMessagingLogger.e("MobileMessaging API returned error (synchronizing messages)!");
                    stats.reportError(MobileMessagingStatsError.SYNC_MESSAGES_ERROR);
                    MessagesSynchronizer.this.scheduleSyncMessagesTask(context, stats, executor, numOfAttemptsDone + 1);
                    return;
                }
                MessagesSynchronizer.this.handler.removeCallbacksAndMessages(null);
                MobileMessageHandler messageHandler = new MobileMessageHandler();
                List<Message> messages = syncMessagesResult.getMessages();
                if (messages == null) {
                    return;
                }
                for (Message message : messages) {
                    Intent intent = new Intent();
                    intent.putExtras(BundleMessageMapper.toBundle(message));
                    messageHandler.handleMessage(context, intent);
                }
            }

            protected void onCancelled() {
                MobileMessagingLogger.e("Error syncing messages!");
                stats.reportError(MobileMessagingStatsError.SYNC_MESSAGES_ERROR);
                MessagesSynchronizer.this.scheduleSyncMessagesTask(context, stats, executor, numOfAttemptsDone + 1);
            }
        }.executeOnExecutor(executor, new Object[0]);
    }

    private void scheduleSyncMessagesTask(final Context context, final MobileMessagingStats stats, final Executor executor, final int numOfAttemptsDone) {
        if (numOfAttemptsDone > 3) {
            MobileMessagingLogger.w("No more retries scheduled for message sync");
            return;
        }
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                MessagesSynchronizer.this.startSyncMessagesTask(context, stats, executor, numOfAttemptsDone);
            }
        }, TimeUnit.SECONDS.toMillis(numOfAttemptsDone * numOfAttemptsDone * 2));
    }
}

