/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.messages;

import java.util.ArrayList;
import java.util.List;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.api.messages.MessageResponse;
import org.infobip.mobile.messaging.api.messages.SyncMessagesResponse;
import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;
import org.infobip.mobile.messaging.geo.Geo;
import org.infobip.mobile.messaging.mobile.UnsuccessfulResult;
import org.json.JSONException;
import org.json.JSONObject;

class SyncMessagesResult
extends UnsuccessfulResult {
    private List<Message> messages;

    SyncMessagesResult(Throwable exception) {
        super(exception);
    }

    SyncMessagesResult(SyncMessagesResponse syncMessagesResponse) {
        super(null);
        if (syncMessagesResponse == null) {
            return;
        }
        List payloads = syncMessagesResponse.getPayloads();
        this.mapResponseToMessage(payloads);
    }

    private void mapResponseToMessage(List<MessageResponse> payloads) {
        if (payloads == null) {
            return;
        }
        this.messages = new ArrayList<Message>(payloads.size());
        for (MessageResponse messageResponse : payloads) {
            if (messageResponse == null) continue;
            Message message = SyncMessagesResult.responseToMessage(messageResponse);
            this.messages.add(message);
        }
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    private static Message responseToMessage(MessageResponse response) {
        JSONObject internalData = null;
        try {
            internalData = response.getInternalData() != null ? new JSONObject(response.getInternalData()) : null;
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        JSONObject customPayload = null;
        try {
            customPayload = response.getCustomPayload() != null ? new JSONObject(response.getCustomPayload()) : null;
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Geo geo = response.getInternalData() != null ? (Geo)new JsonSerializer().deserialize(response.getInternalData(), Geo.class) : null;
        return new Message(response.getMessageId(), response.getTitle(), response.getBody(), response.getSound(), "true".equals(response.getVibrate()), null, "true".equals(response.getSilent()), response.getCategory(), null, System.currentTimeMillis(), 0L, internalData, customPayload, geo, null, Message.Status.UNKNOWN, null);
    }
}

