/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.registration;

import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import java.io.Serializable;
import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingLogger;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.mobile.MobileMessagingError;
import org.infobip.mobile.messaging.mobile.registration.UpsertRegistrationResult;
import org.infobip.mobile.messaging.mobile.registration.UpsertRegistrationTask;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.stats.MobileMessagingStatsError;
import org.infobip.mobile.messaging.util.PreferenceHelper;
import org.infobip.mobile.messaging.util.StringUtils;

public class RegistrationSynchronizer {
    public void updatePushRegistrationStatus(final Context context, final String registrationId, Boolean enabled, final MobileMessagingStats stats, Executor executor) {
        if (StringUtils.isBlank(registrationId)) {
            return;
        }
        new UpsertRegistrationTask(context){

            protected void onPostExecute(UpsertRegistrationResult result) {
                if (result.hasError() || StringUtils.isBlank(result.getDeviceInstanceId())) {
                    MobileMessagingLogger.e("MobileMessaging API returned error (push registration status update)!");
                    stats.reportError(MobileMessagingStatsError.PUSH_REGISTRATION_STATUS_UPDATE_ERROR);
                    Intent registrationSaveError = new Intent(Event.API_COMMUNICATION_ERROR.getKey());
                    registrationSaveError.putExtra("org.infobip.mobile.messaging.exception", (Serializable)MobileMessagingError.createFrom(result.getError()));
                    context.sendBroadcast(registrationSaveError);
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(registrationSaveError);
                    return;
                }
                RegistrationSynchronizer.this.setPushRegistrationEnabled(context, result.getPushRegistrationEnabled());
                RegistrationSynchronizer.this.setDeviceApplicationInstanceId(context, result.getDeviceInstanceId());
                RegistrationSynchronizer.this.setRegistrationIdReported(context, true);
                Intent registrationUpdated = new Intent(Event.PUSH_REGISTRATION_ENABLED.getKey());
                registrationUpdated.putExtra("org.infobip.mobile.messaging.gcm.token", registrationId);
                registrationUpdated.putExtra("org.infobip.mobile.messaging.infobip.token", result.getDeviceInstanceId());
                registrationUpdated.putExtra("org.infobip.mobile.messaging.push.registration.enabled", (Serializable)result.getPushRegistrationEnabled());
                context.sendBroadcast(registrationUpdated);
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(registrationUpdated);
            }

            protected void onCancelled() {
                MobileMessagingLogger.e("Error creating registration!");
                RegistrationSynchronizer.this.setRegistrationIdReported(context, false);
                RegistrationSynchronizer.this.setPushRegistrationEnabled(context, !MobileMessagingCore.getInstance(context).isPushRegistrationEnabled());
                stats.reportError(MobileMessagingStatsError.PUSH_REGISTRATION_STATUS_UPDATE_ERROR);
            }
        }.executeOnExecutor(executor, new Boolean[]{enabled});
    }

    public void synchronize(Context context, String deviceApplicationInstanceId, String registrationId, boolean registrationIdSaved, MobileMessagingStats stats, Executor executor) {
        if (null != deviceApplicationInstanceId && registrationIdSaved) {
            return;
        }
        this.reportRegistration(context, registrationId, stats, executor);
    }

    private void reportRegistration(final Context context, final String registrationId, final MobileMessagingStats stats, Executor executor) {
        if (StringUtils.isBlank(registrationId)) {
            return;
        }
        new UpsertRegistrationTask(context){

            protected void onPostExecute(UpsertRegistrationResult result) {
                if (result.hasError() || StringUtils.isBlank(result.getDeviceInstanceId())) {
                    MobileMessagingLogger.e("MobileMessaging API returned error (registration)!");
                    stats.reportError(MobileMessagingStatsError.REGISTRATION_SYNC_ERROR);
                    Intent registrationSaveError = new Intent(Event.API_COMMUNICATION_ERROR.getKey());
                    registrationSaveError.putExtra("org.infobip.mobile.messaging.exception", (Serializable)MobileMessagingError.createFrom(result.getError()));
                    context.sendBroadcast(registrationSaveError);
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(registrationSaveError);
                    return;
                }
                RegistrationSynchronizer.this.setPushRegistrationEnabled(context, result.getPushRegistrationEnabled());
                RegistrationSynchronizer.this.setDeviceApplicationInstanceId(context, result.getDeviceInstanceId());
                RegistrationSynchronizer.this.setRegistrationIdReported(context, true);
                MobileMessagingCore.getInstance(context).reportSystemData();
                Intent registrationCreated = new Intent(Event.REGISTRATION_CREATED.getKey());
                registrationCreated.putExtra("org.infobip.mobile.messaging.gcm.token", registrationId);
                registrationCreated.putExtra("org.infobip.mobile.messaging.infobip.token", result.getDeviceInstanceId());
                context.sendBroadcast(registrationCreated);
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(registrationCreated);
            }

            protected void onCancelled() {
                MobileMessagingLogger.e("Error creating registration!");
                RegistrationSynchronizer.this.setRegistrationIdReported(context, false);
                RegistrationSynchronizer.this.setPushRegistrationEnabled(context, !MobileMessagingCore.getInstance(context).isPushRegistrationEnabled());
                stats.reportError(MobileMessagingStatsError.REGISTRATION_SYNC_ERROR);
            }
        }.executeOnExecutor(executor, new Boolean[0]);
    }

    private void setPushRegistrationEnabled(Context context, Boolean pushRegistrationEnabled) {
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.PUSH_REGISTRATION_ENABLED, (boolean)pushRegistrationEnabled);
    }

    private void setDeviceApplicationInstanceId(Context context, String registrationId) {
        PreferenceHelper.saveString(context, MobileMessagingProperty.INFOBIP_REGISTRATION_ID, registrationId);
    }

    public void setRegistrationIdReported(Context context, boolean registrationIdSaved) {
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.GCM_REGISTRATION_ID_REPORTED, registrationIdSaved);
    }

    public boolean isRegistrationIdReported(Context context) {
        return PreferenceHelper.findBoolean(context, MobileMessagingProperty.GCM_REGISTRATION_ID_REPORTED);
    }
}

