/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.seen;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import java.io.Serializable;
import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobile.BatchReporter;
import org.infobip.mobile.messaging.mobile.MobileMessagingError;
import org.infobip.mobile.messaging.mobile.seen.SeenStatusReportResult;
import org.infobip.mobile.messaging.mobile.seen.SeenStatusReportTask;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.stats.MobileMessagingStatsError;

public class SeenStatusReporter {
    private static BatchReporter batchReporter = null;

    public void report(final Context context, String[] unreportedSeenMessageIds, final MobileMessagingStats stats, final Executor executor) {
        if (unreportedSeenMessageIds.length == 0) {
            return;
        }
        if (batchReporter == null) {
            batchReporter = new BatchReporter(context);
        }
        batchReporter.put(new Runnable(){

            @Override
            public void run() {
                new SeenStatusReportTask(context){

                    protected void onPostExecute(SeenStatusReportResult result) {
                        if (result.hasError()) {
                            MobileMessagingLogger.e("MobileMessaging API returned error (seen messages)!");
                            stats.reportError(MobileMessagingStatsError.SEEN_REPORTING_ERROR);
                            Intent seenStatusReportError = new Intent(Event.API_COMMUNICATION_ERROR.getKey());
                            seenStatusReportError.putExtra("org.infobip.mobile.messaging.exception", (Serializable)MobileMessagingError.createFrom(result.getError()));
                            context.sendBroadcast(seenStatusReportError);
                            LocalBroadcastManager.getInstance((Context)context).sendBroadcast(seenStatusReportError);
                            return;
                        }
                        Intent seenReportsSent = new Intent(Event.SEEN_REPORTS_SENT.getKey());
                        Bundle extras = new Bundle();
                        extras.putStringArray("org.infobip.mobile.messaging.message.ids", result.getMessageIDs());
                        seenReportsSent.putExtras(extras);
                        context.sendBroadcast(seenReportsSent);
                        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(seenReportsSent);
                    }

                    protected void onCancelled() {
                        stats.reportError(MobileMessagingStatsError.SEEN_REPORTING_ERROR);
                        MobileMessagingLogger.e("Error reporting seen status!");
                    }
                }.executeOnExecutor(executor, new Object[0]);
            }
        });
    }
}

