/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.version;

import android.content.Context;
import java.util.concurrent.TimeUnit;
import org.infobip.mobile.messaging.MobileMessagingLogger;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.mobile.version.VersionCheckResult;
import org.infobip.mobile.messaging.mobile.version.VersionCheckTask;
import org.infobip.mobile.messaging.util.PreferenceHelper;
import org.infobip.mobile.messaging.util.SoftwareInformation;
import org.infobip.mobile.messaging.util.Version;

public class VersionChecker {
    private static final String TAG = "VersionChecker";

    public void check(final Context context) {
        if (!SoftwareInformation.isDebuggableApplicationBuild(context)) {
            return;
        }
        Long lastCheckTime = PreferenceHelper.findLong(context, MobileMessagingProperty.VERSION_CHECK_LAST_TIME);
        Integer minimumInterval = PreferenceHelper.findInt(context, MobileMessagingProperty.VERSION_CHECK_INTERVAL_DAYS);
        if (TimeUnit.MILLISECONDS.toDays(System.currentTimeMillis() - lastCheckTime) < (long)minimumInterval.intValue()) {
            return;
        }
        new VersionCheckTask(context){

            protected void onPostExecute(VersionCheckResult versionCheckResult) {
                super.onPostExecute((Object)versionCheckResult);
                if (versionCheckResult.hasError()) {
                    return;
                }
                String current = SoftwareInformation.getLibraryVersion();
                if (VersionChecker.this.shouldUpdate(versionCheckResult.getVersion(), current)) {
                    MobileMessagingLogger.w(VersionChecker.TAG, "Your library version is outdated, find latest release " + versionCheckResult.getVersion() + " here: " + versionCheckResult.getUpdateUrl());
                }
                PreferenceHelper.saveLong(context, MobileMessagingProperty.VERSION_CHECK_LAST_TIME, System.currentTimeMillis());
            }
        }.execute(new Void[0]);
    }

    private boolean shouldUpdate(String latest, String current) {
        Version latestVersion = new Version(latest);
        Version currentVersion = new Version(current);
        return latestVersion.compareTo(currentVersion) > 0;
    }
}

