/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.geo;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.List;
import org.infobip.mobile.messaging.geo.Area;
import org.infobip.mobile.messaging.geo.GeoEventType;

public class GeoReport
implements Parcelable {
    private Area area;
    private GeoEventType event;
    private String campaignId;
    private String messageId;
    private Long timestampOccured;
    public static final Parcelable.Creator<GeoReport> CREATOR = new Parcelable.Creator<GeoReport>(){

        public GeoReport createFromParcel(Parcel in) {
            return new GeoReport(in);
        }

        public GeoReport[] newArray(int size) {
            return new GeoReport[size];
        }
    };

    public GeoReport(String campaignId, String messageId, GeoEventType event, Area area, Long timestampOccured) {
        this.area = area;
        this.campaignId = campaignId;
        this.messageId = messageId;
        this.event = event;
        this.timestampOccured = timestampOccured;
    }

    private GeoReport(Parcel parcel) {
        this.campaignId = parcel.readString();
        this.messageId = parcel.readString();
        this.event = GeoEventType.valueOf(parcel.readString());
        this.area = (Area)parcel.readParcelable(Area.class.getClassLoader());
        this.timestampOccured = parcel.readLong();
    }

    public static List<GeoReport> createFrom(Bundle bundle) {
        return bundle.getParcelableArrayList("org.infobip.mobile.messaging.geofence.reports");
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public GeoEventType getEvent() {
        return this.event;
    }

    public Area getArea() {
        return this.area;
    }

    public Long getTimestampOccured() {
        return this.timestampOccured;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.campaignId);
        parcel.writeString(this.messageId);
        parcel.writeString(this.event.name());
        parcel.writeParcelable((Parcelable)this.area, i);
        parcel.writeLong(this.timestampOccured.longValue());
    }
}

