/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.data;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import java.io.Serializable;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.UserData;
import org.infobip.mobile.messaging.api.data.UserDataReport;
import org.infobip.mobile.messaging.mobile.MobileApiResourceProvider;
import org.infobip.mobile.messaging.mobile.data.SyncUserDataResult;
import org.infobip.mobile.messaging.util.StringUtils;

@TargetApi(value=14)
class SyncUserDataTask
extends AsyncTask<Void, Void, SyncUserDataResult> {
    private final Context context;

    SyncUserDataTask(Context context) {
        this.context = context;
    }

    protected SyncUserDataResult doInBackground(Void ... notUsed) {
        MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance(this.context);
        String deviceApplicationInstanceId = mobileMessagingCore.getDeviceApplicationInstanceId();
        if (StringUtils.isBlank(deviceApplicationInstanceId)) {
            Log.e((String)"MobileMessaging", (String)"Can't sync user data without valid registration!");
            return new SyncUserDataResult(new Exception("Syncing user data: no valid registration"));
        }
        UserData userData = mobileMessagingCore.getUnreportedUserData();
        if (userData == null) {
            userData = new UserData();
        }
        try {
            UserDataReport request = new UserDataReport(userData.getPredefinedUserData(), userData.getCustomUserData());
            UserDataReport response = MobileApiResourceProvider.INSTANCE.getMobileApiData(this.context).reportUserData(deviceApplicationInstanceId, userData.getExternalUserId(), request);
            return new SyncUserDataResult(response.getPredefinedUserData(), response.getCustomUserData());
        }
        catch (Exception e) {
            mobileMessagingCore.setLastHttpException(e);
            Log.e((String)"MobileMessaging", (String)"Error synchronizing user data!", (Throwable)e);
            this.cancel(true);
            Intent userDataSyncError = new Intent(Event.API_COMMUNICATION_ERROR.getKey());
            userDataSyncError.putExtra("org.infobip.mobile.messaging.exception", (Serializable)e);
            this.context.sendBroadcast(userDataSyncError);
            LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(userDataSyncError);
            return new SyncUserDataResult(e);
        }
    }
}

