/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.messages;

import android.os.Bundle;
import java.util.ArrayList;
import java.util.List;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.api.messages.MessageResponse;
import org.infobip.mobile.messaging.api.messages.SyncMessagesResponse;
import org.infobip.mobile.messaging.mobile.UnsuccessfulResult;

class SyncMessagesResult
extends UnsuccessfulResult {
    private List<Message> messages;

    SyncMessagesResult(Throwable exception) {
        super(exception);
    }

    SyncMessagesResult(SyncMessagesResponse syncMessagesResponse) {
        super(null);
        List payloads = syncMessagesResponse.getPayloads();
        this.mapResponseToMessage(payloads);
    }

    private void mapResponseToMessage(List<MessageResponse> payloads) {
        if (payloads == null) {
            return;
        }
        this.messages = new ArrayList<Message>(payloads.size());
        for (MessageResponse messageResponse : payloads) {
            if (messageResponse == null) continue;
            Message message = SyncMessageDelivery.toMessage(messageResponse);
            this.messages.add(message);
        }
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    private static class SyncMessageDelivery
    extends Message {
        private SyncMessageDelivery() {
        }

        static Message toMessage(MessageResponse messageResponse) {
            Bundle bundle = new Bundle();
            bundle.putString(Message.BundleField.MESSAGE_ID.getKey(), messageResponse.getMessageId());
            bundle.putString(Message.BundleField.TITLE.getKey(), messageResponse.getTitle());
            bundle.putString(Message.BundleField.BODY.getKey(), messageResponse.getBody());
            bundle.putString(Message.BundleField.SOUND.getKey(), messageResponse.getSound());
            bundle.putString(Message.BundleField.VIBRATE.getKey(), messageResponse.getVibrate());
            bundle.putString(Message.BundleField.SILENT.getKey(), messageResponse.getSilent());
            bundle.putString(Message.BundleField.CUSTOM_PAYLOAD.getKey(), messageResponse.getCustomPayload());
            bundle.putString(Message.BundleField.INTERNAL_DATA.getKey(), messageResponse.getInternalData());
            return Message.createFrom(bundle);
        }
    }
}

