/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.dal.json;

import android.support.annotation.NonNull;
import java.util.ArrayList;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;
import org.infobip.mobile.messaging.geo.Area;
import org.infobip.mobile.messaging.geo.Geo;

public class InternalDataMapper {
    private static final JsonSerializer serializer = new JsonSerializer();

    public static String createInternalDataForFCMBasedOnMessageContents(@NonNull Message message) {
        return InternalDataMapper.createInternalDataForMessage(message);
    }

    public static String createInternalDataBasedOnMessageContents(@NonNull Message message) {
        return InternalDataMapper.createInternalDataForMessage(message);
    }

    public static void updateMessageWithInternalData(@NonNull Message message, String internalDataJson) {
        InternalData internalData = (InternalData)serializer.deserialize(internalDataJson, InternalData.class);
        message.setGeo(internalData);
        if (internalData == null || internalData.silent == null) {
            return;
        }
        message.setTitle(internalData.silent.title);
        message.setBody(internalData.silent.body);
        message.setSound(internalData.silent.sound);
        message.setVibrate(Boolean.valueOf(internalData.silent.vibrate.toString()));
    }

    public static String getInternalDataTitle(String json) {
        try {
            return ((InternalData)new JsonSerializer().deserialize((String)json, InternalData.class)).silent.title;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getInternalDataBody(String json) {
        try {
            return ((InternalData)new JsonSerializer().deserialize((String)json, InternalData.class)).silent.body;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getInternalDataSound(String json) {
        try {
            return ((InternalData)new JsonSerializer().deserialize((String)json, InternalData.class)).silent.sound;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean getInternalDataVibrate(String json, boolean defaultVibrate) {
        try {
            Object vibrate = ((InternalData)new JsonSerializer().deserialize((String)json, InternalData.class)).silent.vibrate;
            return Boolean.valueOf(vibrate.toString());
        }
        catch (Exception e) {
            return defaultVibrate;
        }
    }

    public static String getInternalDataCategory(String json) {
        try {
            return ((InternalData)new JsonSerializer().deserialize((String)json, InternalData.class)).silent.category;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static <VibrateValueType> String createInternalDataForMessage(Message message) {
        InternalData internalData = null;
        if (message.getGeo() != null) {
            internalData = (InternalData)serializer.deserialize(serializer.serialize((Object)message.getGeo()), InternalData.class);
        }
        if (message.isSilent()) {
            if (internalData == null) {
                internalData = new InternalData();
            }
            if (internalData.silent == null) {
                internalData.silent = new Silent();
            }
            internalData.silent.title = message.getTitle();
            internalData.silent.body = message.getBody();
            internalData.silent.sound = message.getSound();
            if (internalData.silent.vibrate instanceof Boolean) {
                internalData.silent.vibrate = message.isVibrate();
            } else if (internalData.silent.vibrate instanceof String) {
                internalData.silent.vibrate = message.isVibrate() ? "true" : "false";
            }
            internalData.silent.category = message.getCategory();
        }
        return internalData != null ? serializer.serialize(internalData) : null;
    }

    private static class InternalData<VibrateValueType>
    extends Geo {
        Silent<VibrateValueType> silent;

        InternalData() {
            super(null, null, null, null, null, null, new ArrayList<Area>(), null);
        }
    }

    private static class Silent<VibrateValueType> {
        String title;
        String body;
        String sound;
        VibrateValueType vibrate;
        String category;

        private Silent() {
        }
    }
}

