/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.geo;

import com.google.android.gms.location.Geofence;
import java.util.Date;

public class Area {
    private String id;
    private String title;
    private Double latitude;
    private Double longitude;
    private Integer radiusInMeters;

    public Area(String id, String title, Double latitude, Double longitude, Integer radiusInMeters) {
        this.id = id;
        this.title = title;
        this.latitude = latitude;
        this.longitude = longitude;
        this.radiusInMeters = radiusInMeters;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public Integer getRadius() {
        return this.radiusInMeters;
    }

    Geofence toGeofence(Date expiryDate) {
        Long expirationDurationMillis = 0L;
        if (expiryDate != null) {
            expirationDurationMillis = expiryDate.getTime() - System.currentTimeMillis();
        }
        if (expirationDurationMillis <= 0L) {
            expirationDurationMillis = -1L;
        }
        return new Geofence.Builder().setCircularRegion(this.getLatitude().doubleValue(), this.getLongitude().doubleValue(), (float)this.getRadius().intValue()).setRequestId(this.getId()).setTransitionTypes(1).setExpirationDuration(expirationDurationMillis.longValue()).build();
    }

    public boolean isValid() {
        return this.getId() != null && this.getLatitude() != null && this.getLongitude() != null && this.getRadius() != null;
    }
}

