/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.geo;

import android.os.Bundle;
import android.util.Log;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.infobip.mobile.messaging.MobileMessagingLogger;
import org.infobip.mobile.messaging.dal.bundle.BundleMapper;
import org.infobip.mobile.messaging.geo.Area;
import org.infobip.mobile.messaging.geo.DeliveryTime;
import org.infobip.mobile.messaging.geo.GeoEventSettings;
import org.infobip.mobile.messaging.util.DateTimeUtil;
import org.infobip.mobile.messaging.util.ISO8601DateParseException;

public class Geo {
    private Double triggeringLatitude;
    private Double triggeringLongitude;
    private DeliveryTime deliveryTime;
    private String expiryTime;
    private String startTime;
    private String campaignId;
    @SerializedName(value="geo")
    private List<Area> areasList = new ArrayList<Area>();
    @SerializedName(value="event")
    private List<GeoEventSettings> eventSettings = new ArrayList<GeoEventSettings>();

    public Geo(Double triggeringLatitude, Double triggeringLongitude, DeliveryTime deliveryTime, String expiryTime, String startTime, String campaignId, List<Area> areasList, List<GeoEventSettings> eventSettings) {
        this.triggeringLatitude = triggeringLatitude;
        this.triggeringLongitude = triggeringLongitude;
        this.deliveryTime = deliveryTime;
        this.expiryTime = expiryTime;
        this.startTime = startTime;
        this.campaignId = campaignId;
        this.areasList = areasList;
        this.eventSettings = eventSettings;
    }

    public static Geo createFrom(Bundle bundle) {
        return BundleMapper.geoFromBundle(bundle);
    }

    public Double getTriggeringLatitude() {
        return this.triggeringLatitude;
    }

    public Double getTriggeringLongitude() {
        return this.triggeringLongitude;
    }

    public List<Area> getAreasList() {
        return this.areasList;
    }

    protected List<GeoEventSettings> getEvents() {
        return this.eventSettings;
    }

    protected Date getExpiryDate() {
        try {
            return DateTimeUtil.ISO8601DateFromString(this.expiryTime);
        }
        catch (ISO8601DateParseException e) {
            MobileMessagingLogger.e("Cannot parse expiry date: " + e.getMessage());
            MobileMessagingLogger.d(Log.getStackTraceString((Throwable)e));
            return null;
        }
    }

    boolean isEligibleForMonitoring() {
        Date now = new Date();
        return (this.getStartDate() == null || this.getStartDate().before(now)) && !this.isExpired();
    }

    boolean isExpired() {
        Date now = new Date();
        Date expiryDate = this.getExpiryDate();
        return expiryDate != null && expiryDate.before(now);
    }

    DeliveryTime getDeliveryTime() {
        return this.deliveryTime;
    }

    Date getStartDate() {
        try {
            return DateTimeUtil.ISO8601DateFromString(this.startTime);
        }
        catch (ISO8601DateParseException e) {
            MobileMessagingLogger.e("Cannot parse start date: " + e.getMessage());
            MobileMessagingLogger.d(Log.getStackTraceString((Throwable)e));
            return null;
        }
    }

    String getCampaignId() {
        return this.campaignId;
    }

    String getExpiryTime() {
        return this.expiryTime;
    }

    String getStartTime() {
        return this.startTime;
    }
}

