/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.geo;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationServices;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingLogger;
import org.infobip.mobile.messaging.api.support.Tuple;
import org.infobip.mobile.messaging.gcm.PlayServicesSupport;
import org.infobip.mobile.messaging.geo.Area;
import org.infobip.mobile.messaging.geo.ConfigurationException;
import org.infobip.mobile.messaging.geo.Geo;
import org.infobip.mobile.messaging.geo.GeoSQLiteMessageStore;
import org.infobip.mobile.messaging.geo.GeofenceTransitionsIntentService;
import org.infobip.mobile.messaging.geo.GeofencingConsistencyReceiver;
import org.infobip.mobile.messaging.storage.MessageStore;

public class Geofencing
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    private static String TAG = "Geofencing";
    private static Context context;
    private static Geofencing instance;
    private GoogleApiClient googleApiClient;
    private List<Geofence> geofences;
    private PendingIntent geofencePendingIntent;
    private MessageStore messageStore;
    private GoogleApiClientRequestType requestType;

    private Geofencing(Context context) {
        this.checkRequiredService(context, GeofenceTransitionsIntentService.class);
        Geofencing.context = context;
        this.requestType = GoogleApiClientRequestType.NONE;
        this.geofences = new ArrayList<Geofence>();
        this.messageStore = MobileMessagingCore.getInstance(context).getMessageStoreForGeo();
        this.googleApiClient = new GoogleApiClient.Builder(context).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
    }

    public static Geofencing getInstance(Context context) {
        if (instance != null) {
            return instance;
        }
        instance = new Geofencing(context);
        return instance;
    }

    public static void scheduleRefresh(Context context) {
        Geofencing.scheduleRefresh(context, new Date());
    }

    private static void scheduleRefresh(Context context, Date when) {
        MobileMessagingLogger.i(TAG, "Next refresh in: " + when);
        GeofencingConsistencyReceiver.scheduleConsistencyAlarm(context, 0, when, "org.infobip.mobile.messaging.geo.intent.SCHEDULED_GEO_REFRESH", 0);
    }

    public static void scheduleExpiry(Context context, Date when) {
        GeofencingConsistencyReceiver.scheduleConsistencyAlarm(context, 0, when, "org.infobip.mobile.messaging.geo.intent.SCHEDULED_GEO_EXPIRE", 0);
    }

    public void removeExpiredAreasFromStorage() {
        GeoSQLiteMessageStore messageStoreForGeo = (GeoSQLiteMessageStore)MobileMessagingCore.getInstance(context).getMessageStoreForGeo();
        List<Message> messages = messageStoreForGeo.findAll(context);
        ArrayList<String> messageIdsToDelete = new ArrayList<String>(messages.size());
        Date now = new Date();
        for (Message message : messages) {
            Geo geo = message.getGeo();
            if (geo == null) continue;
            List<Area> areasList = geo.getAreasList();
            Date expiryDate = geo.getExpiryDate();
            if (areasList == null || areasList.isEmpty()) continue;
            for (Area area : areasList) {
                if (!area.isValid() || expiryDate == null || !expiryDate.before(now)) continue;
                messageIdsToDelete.add(message.getMessageId());
            }
        }
        if (!messageIdsToDelete.isEmpty()) {
            messageStoreForGeo.deleteByIds(context, messageIdsToDelete.toArray(new String[0]));
        }
    }

    static Tuple<List<Geofence>, Tuple<Date, Date>> calculateGeofencesToMonitorAndNextCheckDates(MessageStore messageStore) {
        Date nextCheckRefreshDate = null;
        Date nextCheckExpireDate = null;
        HashMap<String, Geofence> geofences = new HashMap<String, Geofence>();
        HashMap<String, Date> expiryDates = new HashMap<String, Date>();
        List<Message> messages = messageStore.findAll(context);
        for (Message message : messages) {
            Geo geo = message.getGeo();
            if (geo == null || geo.getAreasList() == null || geo.getAreasList().isEmpty()) continue;
            nextCheckExpireDate = Geofencing.calculateNextCheckDateForGeoExpiry(geo, nextCheckExpireDate);
            Set<String> finishedCampaignIds = MobileMessagingCore.getInstance(context).getFinishedCampaignIds();
            if (finishedCampaignIds.contains(geo.getCampaignId())) continue;
            if (geo.isEligibleForMonitoring()) {
                List<Area> geoAreasList = message.getGeo().getAreasList();
                for (Area area : geoAreasList) {
                    Date expiry;
                    if (!area.isValid() || (expiry = (Date)expiryDates.get(area.getId())) != null && expiry.after(geo.getExpiryDate())) continue;
                    expiryDates.put(area.getId(), geo.getExpiryDate());
                    geofences.put(area.getId(), area.toGeofence(geo.getExpiryDate()));
                }
            }
            nextCheckRefreshDate = Geofencing.calculateNextCheckDateForGeoStart(geo, nextCheckRefreshDate);
        }
        ArrayList geofenceList = new ArrayList(geofences.values());
        return new Tuple(geofenceList, (Object)new Tuple(nextCheckRefreshDate, nextCheckExpireDate));
    }

    private static Date calculateNextCheckDateForGeoStart(Geo geo, Date oldCheckDate) {
        Date now = new Date();
        Date expiryDate = geo.getExpiryDate();
        if (expiryDate != null && expiryDate.before(now)) {
            return oldCheckDate;
        }
        Date startDate = geo.getStartDate();
        if (startDate == null || startDate.before(now)) {
            return oldCheckDate;
        }
        if (oldCheckDate != null && oldCheckDate.before(startDate)) {
            return oldCheckDate;
        }
        return startDate;
    }

    private static Date calculateNextCheckDateForGeoExpiry(Geo geo, Date oldCheckDate) {
        Date now = new Date();
        Date expiryDate = geo.getExpiryDate();
        if (expiryDate == null) {
            if (oldCheckDate == null) {
                return null;
            }
            return oldCheckDate;
        }
        if (oldCheckDate != null && oldCheckDate.before(expiryDate)) {
            if (oldCheckDate.before(now)) {
                return now;
            }
            return oldCheckDate;
        }
        if (expiryDate.before(now)) {
            return now;
        }
        return expiryDate;
    }

    public void startGeoMonitoring() {
        if (!PlayServicesSupport.isPlayServicesAvailable(context) || !MobileMessagingCore.isGeofencingActivated(context)) {
            return;
        }
        if (!this.checkRequiredPermissions()) {
            return;
        }
        Tuple<List<Geofence>, Tuple<Date, Date>> tuple = Geofencing.calculateGeofencesToMonitorAndNextCheckDates(this.messageStore);
        Date nextRefreshDate = (Date)((Tuple)tuple.getRight()).getLeft();
        Date nextExpireDate = (Date)((Tuple)tuple.getRight()).getRight();
        Geofencing.scheduleRefresh(context, nextRefreshDate);
        Geofencing.scheduleExpiry(context, nextExpireDate);
        this.geofences = (List)tuple.getLeft();
        if (this.geofences.isEmpty()) {
            return;
        }
        this.requestType = GoogleApiClientRequestType.ADD_GEOFENCES;
        if (!this.googleApiClient.isConnected()) {
            this.googleApiClient.connect();
            return;
        }
        LocationServices.GeofencingApi.addGeofences(this.googleApiClient, this.geofencingRequest(), this.geofencePendingIntent()).setResultCallback((ResultCallback)new ResultCallback<Status>(){

            public void onResult(@NonNull Status status) {
                Geofencing.this.logGeofenceStatus(status, true);
                Geofencing.this.requestType = GoogleApiClientRequestType.NONE;
                MobileMessagingCore.getInstance(context).setAllActiveGeoAreasMonitored(status.isSuccess());
            }
        });
    }

    public void stopGeoMonitoring() {
        if (!this.checkRequiredPermissions()) {
            return;
        }
        this.requestType = GoogleApiClientRequestType.REMOVE_GEOFENCES;
        if (!this.googleApiClient.isConnected()) {
            this.googleApiClient.connect();
            return;
        }
        LocationServices.GeofencingApi.removeGeofences(this.googleApiClient, this.geofencePendingIntent()).setResultCallback((ResultCallback)new ResultCallback<Status>(){

            public void onResult(@NonNull Status status) {
                Geofencing.this.logGeofenceStatus(status, false);
                Geofencing.this.requestType = GoogleApiClientRequestType.NONE;
                MobileMessagingCore.getInstance(context).setAllActiveGeoAreasMonitored(!status.isSuccess());
            }
        });
    }

    private boolean checkRequiredPermissions() {
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
            MobileMessagingLogger.e("Unable to initialize geofencing", new ConfigurationException(ConfigurationException.Reason.MISSING_REQUIRED_PERMISSION, "android.permission.ACCESS_FINE_LOCATION"));
            return false;
        }
        return true;
    }

    private void checkRequiredService(Context context, Class serviceClass) {
        String serviceName = serviceClass.getCanonicalName();
        ComponentName componentName = new ComponentName(context.getPackageName(), serviceName);
        try {
            context.getPackageManager().getServiceInfo(componentName, 128);
        }
        catch (PackageManager.NameNotFoundException localNameNotFoundException) {
            throw new ConfigurationException(ConfigurationException.Reason.MISSING_REQUIRED_SERVICE, serviceName);
        }
    }

    private void logGeofenceStatus(@NonNull Status status, boolean activated) {
        if (status.isSuccess()) {
            MobileMessagingLogger.d(TAG, "Geofencing monitoring " + (activated ? "" : "de-") + "activated successfully");
        } else {
            MobileMessagingLogger.e(TAG, "Geofencing monitoring " + (activated ? "" : "de-") + "activation failed", new Throwable(status.getStatusMessage()));
        }
    }

    private GeofencingRequest geofencingRequest() {
        GeofencingRequest.Builder builder = new GeofencingRequest.Builder();
        builder.setInitialTrigger(1);
        builder.addGeofences(this.geofences);
        return builder.build();
    }

    private PendingIntent geofencePendingIntent() {
        if (this.geofencePendingIntent == null) {
            Intent intent = new Intent(context, GeofenceTransitionsIntentService.class);
            this.geofencePendingIntent = PendingIntent.getService((Context)context, (int)0, (Intent)intent, (int)0x8000000);
        }
        return this.geofencePendingIntent;
    }

    public void onConnected(@Nullable Bundle bundle) {
        MobileMessagingLogger.d(TAG, "GoogleApiClient connected");
        if (GoogleApiClientRequestType.ADD_GEOFENCES.equals((Object)this.requestType)) {
            this.startGeoMonitoring();
        } else if (GoogleApiClientRequestType.REMOVE_GEOFENCES.equals((Object)this.requestType)) {
            this.stopGeoMonitoring();
        }
    }

    public void onConnectionSuspended(int i) {
    }

    public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        MobileMessagingLogger.e(TAG, connectionResult.getErrorMessage(), new ConfigurationException(ConfigurationException.Reason.CHECK_LOCATION_SETTINGS));
    }

    private static enum GoogleApiClientRequestType {
        ADD_GEOFENCES,
        REMOVE_GEOFENCES,
        NONE;

    }
}

