/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.data;

import android.content.Context;
import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.MobileMessaging;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingLogger;
import org.infobip.mobile.messaging.UserData;
import org.infobip.mobile.messaging.mobile.MobileMessagingError;
import org.infobip.mobile.messaging.mobile.data.SyncUserDataResult;
import org.infobip.mobile.messaging.mobile.data.SyncUserDataTask;
import org.infobip.mobile.messaging.mobile.data.UserDataMapper;
import org.infobip.mobile.messaging.mobile.synchronizer.RetryableSynchronizer;
import org.infobip.mobile.messaging.mobile.synchronizer.Task;
import org.infobip.mobile.messaging.platform.Broadcaster;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.stats.MobileMessagingStatsError;

public class UserDataSynchronizer
extends RetryableSynchronizer {
    private Broadcaster broadcaster;

    public UserDataSynchronizer(Context context, MobileMessagingStats stats, Executor executor, Broadcaster broadcaster) {
        super(context, stats, executor);
        this.broadcaster = broadcaster;
    }

    @Override
    public void synchronize(final MobileMessaging.ResultListener listener) {
        final UserData userDataToReport = MobileMessagingCore.getInstance(this.context).getUnreportedUserData();
        if (userDataToReport == null) {
            return;
        }
        new SyncUserDataTask(this.context){

            protected void onPostExecute(SyncUserDataResult syncUserDataResult) {
                if (syncUserDataResult.hasError()) {
                    MobileMessagingLogger.e("MobileMessaging API returned error (user data)!");
                    UserDataSynchronizer.this.stats.reportError(MobileMessagingStatsError.USER_DATA_SYNC_ERROR);
                    if (syncUserDataResult.hasInvalidParameterError()) {
                        MobileMessagingCore.getInstance(UserDataSynchronizer.this.context).setUserDataReportedWithError();
                        if (listener != null) {
                            listener.onError(MobileMessagingError.createFrom(syncUserDataResult.getError()));
                        }
                    } else {
                        MobileMessagingLogger.v("User data synchronization will be postponed to a later time due to communication error");
                        if (listener != null) {
                            listener.onResult(UserData.merge(MobileMessagingCore.getInstance(UserDataSynchronizer.this.context).getUserData(), userDataToReport));
                        } else {
                            UserDataSynchronizer.this.retry(syncUserDataResult);
                        }
                    }
                    UserDataSynchronizer.this.broadcaster.error(MobileMessagingError.createFrom(syncUserDataResult.getError()));
                    return;
                }
                UserData userData = UserDataMapper.fromUserDataReport(userDataToReport.getExternalUserId(), syncUserDataResult.getPredefined(), syncUserDataResult.getCustom());
                MobileMessagingCore.getInstance(UserDataSynchronizer.this.context).setUserDataReported(userData);
                UserDataSynchronizer.this.broadcaster.userDataReported(userData);
                if (listener != null) {
                    listener.onResult(userData);
                }
            }

            protected void onCancelled(SyncUserDataResult syncUserDataResult) {
                MobileMessagingLogger.e("Error reporting user data!");
                UserDataSynchronizer.this.stats.reportError(MobileMessagingStatsError.USER_DATA_SYNC_ERROR);
                UserDataSynchronizer.this.broadcaster.error(MobileMessagingError.createFrom(syncUserDataResult.getError()));
                MobileMessagingLogger.v("User data synchronization will be postponed to a later time due to communication error");
                if (listener != null) {
                    listener.onResult(MobileMessagingCore.getInstance(UserDataSynchronizer.this.context).getUserData());
                } else {
                    UserDataSynchronizer.this.retry(syncUserDataResult);
                }
            }
        }.executeOnExecutor(this.executor, new Void[0]);
    }

    @Override
    public Task getTask() {
        return Task.SYNC_USER_DATA;
    }
}

