/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.geo;

import android.content.Context;
import android.support.annotation.NonNull;
import java.util.Arrays;
import java.util.List;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingLogger;
import org.infobip.mobile.messaging.geo.GeoAreasHandler;
import org.infobip.mobile.messaging.geo.GeoReport;
import org.infobip.mobile.messaging.geo.GeoReportHelper;
import org.infobip.mobile.messaging.mobile.MobileMessagingError;
import org.infobip.mobile.messaging.mobile.geo.GeoReportingResult;
import org.infobip.mobile.messaging.mobile.geo.GeoReportingTask;
import org.infobip.mobile.messaging.mobile.synchronizer.RetryableSynchronizer;
import org.infobip.mobile.messaging.mobile.synchronizer.Task;
import org.infobip.mobile.messaging.platform.Broadcaster;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.stats.MobileMessagingStatsError;

public class GeoReporter
extends RetryableSynchronizer {
    private Broadcaster broadcaster;

    public GeoReporter(Context context, Broadcaster broadcaster, MobileMessagingStats stats) {
        super(context, stats);
        this.broadcaster = broadcaster;
    }

    @Override
    public void synchronize() {
        MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance(this.context);
        Object[] reports = mobileMessagingCore.removeUnreportedGeoEvents();
        if (reports.length == 0 || !mobileMessagingCore.isPushRegistrationEnabled()) {
            return;
        }
        new GeoReportingTask(this.context, (GeoReport[])reports){
            final /* synthetic */ GeoReport[] val$reports;
            {
                this.val$reports = geoReportArray;
                super(context);
            }

            protected void onPostExecute(GeoReportingResult result) {
                GeoReporter.this.handleSuccess(GeoReporter.this.context, this.val$reports, result);
                GeoAreasHandler.handleGeoReportingResult(GeoReporter.this.context, result);
                if (result.hasError()) {
                    GeoReporter.this.retry(result);
                }
            }

            protected void onCancelled(GeoReportingResult result) {
                GeoReporter.this.handleError(GeoReporter.this.context, result.getError(), this.val$reports);
                GeoAreasHandler.handleGeoReportingResult(GeoReporter.this.context, result);
                GeoReporter.this.retry(result);
            }
        }.execute(reports);
    }

    @NonNull
    public GeoReportingResult reportSync(@NonNull Context context, @NonNull GeoReport[] geoReports) {
        try {
            GeoReportingResult result = GeoReportingTask.executeSync(context, geoReports);
            this.handleSuccess(context, geoReports, result);
            return result;
        }
        catch (Exception e) {
            this.handleError(context, e, geoReports);
            return new GeoReportingResult(e);
        }
    }

    private void handleSuccess(Context context, GeoReport[] geoReports, GeoReportingResult result) {
        List<GeoReport> geoReportsToBroadcast = GeoReportHelper.filterOutNonActiveReports(context, Arrays.asList(geoReports), result);
        this.broadcaster.geoReported(geoReportsToBroadcast);
    }

    private void handleError(Context context, Throwable error, GeoReport[] geoReports) {
        MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance(context);
        MobileMessagingLogger.e("Error reporting geo areas: " + error);
        mobileMessagingCore.setLastHttpException(error);
        mobileMessagingCore.getStats().reportError(MobileMessagingStatsError.GEO_REPORTING_ERROR);
        mobileMessagingCore.addUnreportedGeoEvents(geoReports);
        this.broadcaster.error(MobileMessagingError.createFrom(error));
    }

    @Override
    public Task getTask() {
        return Task.GEO_REPORT;
    }
}

