/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.registration;

import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import java.io.Serializable;
import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingLogger;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.mobile.MobileMessagingError;
import org.infobip.mobile.messaging.mobile.registration.UpsertRegistrationResult;
import org.infobip.mobile.messaging.mobile.registration.UpsertRegistrationTask;
import org.infobip.mobile.messaging.mobile.synchronizer.RetryableSynchronizer;
import org.infobip.mobile.messaging.mobile.synchronizer.Task;
import org.infobip.mobile.messaging.platform.Broadcaster;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.stats.MobileMessagingStatsError;
import org.infobip.mobile.messaging.util.PreferenceHelper;
import org.infobip.mobile.messaging.util.StringUtils;

public class RegistrationSynchronizer
extends RetryableSynchronizer {
    private Broadcaster broadcaster;

    public RegistrationSynchronizer(Context context, MobileMessagingStats stats, Executor executor, Broadcaster broadcaster) {
        super(context, stats, executor);
        this.broadcaster = broadcaster;
    }

    @Override
    public void updatePushRegistrationStatus(Boolean enabled) {
        final String registrationId = MobileMessagingCore.getInstance(this.context).getRegistrationId();
        if (StringUtils.isBlank(registrationId)) {
            return;
        }
        new UpsertRegistrationTask(this.context){

            protected void onPostExecute(UpsertRegistrationResult result) {
                if (result.hasError() || StringUtils.isBlank(result.getDeviceInstanceId())) {
                    MobileMessagingLogger.e("MobileMessaging API returned error (push registration status update)!");
                    RegistrationSynchronizer.this.stats.reportError(MobileMessagingStatsError.PUSH_REGISTRATION_STATUS_UPDATE_ERROR);
                    Intent registrationSaveError = new Intent(Event.API_COMMUNICATION_ERROR.getKey());
                    registrationSaveError.putExtra("org.infobip.mobile.messaging.exception", (Serializable)MobileMessagingError.createFrom(result.getError()));
                    RegistrationSynchronizer.this.context.sendBroadcast(registrationSaveError);
                    LocalBroadcastManager.getInstance((Context)RegistrationSynchronizer.this.context).sendBroadcast(registrationSaveError);
                    return;
                }
                RegistrationSynchronizer.this.setPushRegistrationEnabled(RegistrationSynchronizer.this.context, result.getPushRegistrationEnabled());
                RegistrationSynchronizer.this.setDeviceApplicationInstanceId(RegistrationSynchronizer.this.context, result.getDeviceInstanceId());
                RegistrationSynchronizer.this.setRegistrationIdReported(RegistrationSynchronizer.this.context, true);
                RegistrationSynchronizer.this.broadcaster.registrationEnabled(registrationId, result.getDeviceInstanceId(), result.getPushRegistrationEnabled());
            }

            protected void onCancelled(UpsertRegistrationResult upsertRegistrationResult) {
                MobileMessagingLogger.e("Error updating registration!");
                RegistrationSynchronizer.this.setRegistrationIdReported(RegistrationSynchronizer.this.context, false);
                RegistrationSynchronizer.this.setPushRegistrationEnabled(RegistrationSynchronizer.this.context, !MobileMessagingCore.getInstance(RegistrationSynchronizer.this.context).isPushRegistrationEnabled());
                RegistrationSynchronizer.this.stats.reportError(MobileMessagingStatsError.PUSH_REGISTRATION_STATUS_UPDATE_ERROR);
                RegistrationSynchronizer.this.broadcaster.error(MobileMessagingError.createFrom(upsertRegistrationResult.getError()));
            }
        }.executeOnExecutor(this.executor, new Boolean[]{enabled});
    }

    @Override
    public Task getTask() {
        return Task.UPDATE_REGISTRATION_STATUS;
    }

    @Override
    public void synchronize() {
        String deviceApplicationInstanceId = MobileMessagingCore.getInstance(this.context).getDeviceApplicationInstanceId();
        if (null != deviceApplicationInstanceId && this.isRegistrationIdReported(this.context)) {
            return;
        }
        String registrationId = MobileMessagingCore.getInstance(this.context).getRegistrationId();
        this.reportRegistration(registrationId);
    }

    private void reportRegistration(final String registrationId) {
        if (StringUtils.isBlank(registrationId)) {
            return;
        }
        new UpsertRegistrationTask(this.context){

            protected void onPostExecute(UpsertRegistrationResult result) {
                if (result.hasError() || StringUtils.isBlank(result.getDeviceInstanceId())) {
                    MobileMessagingLogger.e("MobileMessaging API returned error (registration)!");
                    RegistrationSynchronizer.this.stats.reportError(MobileMessagingStatsError.REGISTRATION_SYNC_ERROR);
                    RegistrationSynchronizer.this.retry(result);
                    Intent registrationSaveError = new Intent(Event.API_COMMUNICATION_ERROR.getKey());
                    registrationSaveError.putExtra("org.infobip.mobile.messaging.exception", (Serializable)MobileMessagingError.createFrom(result.getError()));
                    RegistrationSynchronizer.this.context.sendBroadcast(registrationSaveError);
                    LocalBroadcastManager.getInstance((Context)RegistrationSynchronizer.this.context).sendBroadcast(registrationSaveError);
                    return;
                }
                RegistrationSynchronizer.this.setPushRegistrationEnabled(RegistrationSynchronizer.this.context, result.getPushRegistrationEnabled());
                RegistrationSynchronizer.this.setDeviceApplicationInstanceId(RegistrationSynchronizer.this.context, result.getDeviceInstanceId());
                RegistrationSynchronizer.this.setRegistrationIdReported(RegistrationSynchronizer.this.context, true);
                MobileMessagingCore.getInstance(RegistrationSynchronizer.this.context).reportSystemData();
                RegistrationSynchronizer.this.broadcaster.registrationCreated(registrationId, result.getDeviceInstanceId());
            }

            protected void onCancelled(UpsertRegistrationResult result) {
                MobileMessagingLogger.e("Error creating registration!");
                RegistrationSynchronizer.this.setRegistrationIdReported(RegistrationSynchronizer.this.context, false);
                RegistrationSynchronizer.this.setPushRegistrationEnabled(RegistrationSynchronizer.this.context, !MobileMessagingCore.getInstance(RegistrationSynchronizer.this.context).isPushRegistrationEnabled());
                RegistrationSynchronizer.this.retry(result);
                RegistrationSynchronizer.this.stats.reportError(MobileMessagingStatsError.REGISTRATION_SYNC_ERROR);
                RegistrationSynchronizer.this.broadcaster.error(MobileMessagingError.createFrom(result.getError()));
            }
        }.executeOnExecutor(this.executor, new Boolean[0]);
    }

    private void setPushRegistrationEnabled(Context context, Boolean pushRegistrationEnabled) {
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.PUSH_REGISTRATION_ENABLED, (boolean)pushRegistrationEnabled);
    }

    private void setDeviceApplicationInstanceId(Context context, String registrationId) {
        PreferenceHelper.saveString(context, MobileMessagingProperty.INFOBIP_REGISTRATION_ID, registrationId);
    }

    public void setRegistrationIdReported(Context context, boolean registrationIdSaved) {
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.GCM_REGISTRATION_ID_REPORTED, registrationIdSaved);
    }

    public boolean isRegistrationIdReported(Context context) {
        return PreferenceHelper.findBoolean(context, MobileMessagingProperty.GCM_REGISTRATION_ID_REPORTED);
    }
}

