/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.version;

import android.content.Context;
import java.util.concurrent.TimeUnit;
import org.infobip.mobile.messaging.MobileMessagingLogger;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.mobile.synchronizer.RetryableSynchronizer;
import org.infobip.mobile.messaging.mobile.synchronizer.Task;
import org.infobip.mobile.messaging.mobile.version.VersionCheckResult;
import org.infobip.mobile.messaging.mobile.version.VersionCheckTask;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.stats.MobileMessagingStatsError;
import org.infobip.mobile.messaging.util.PreferenceHelper;
import org.infobip.mobile.messaging.util.SoftwareInformation;
import org.infobip.mobile.messaging.util.Version;

public class VersionChecker
extends RetryableSynchronizer {
    private static final String TAG = "VersionChecker";

    public VersionChecker(Context context, MobileMessagingStats stats) {
        super(context, stats);
    }

    @Override
    public void synchronize() {
        if (!SoftwareInformation.isDebuggableApplicationBuild(this.context)) {
            return;
        }
        Long lastCheckTime = PreferenceHelper.findLong(this.context, MobileMessagingProperty.VERSION_CHECK_LAST_TIME);
        Integer minimumInterval = PreferenceHelper.findInt(this.context, MobileMessagingProperty.VERSION_CHECK_INTERVAL_DAYS);
        if (TimeUnit.MILLISECONDS.toDays(System.currentTimeMillis() - lastCheckTime) < (long)minimumInterval.intValue()) {
            return;
        }
        new VersionCheckTask(this.context){

            protected void onPostExecute(VersionCheckResult versionCheckResult) {
                if (versionCheckResult.hasError()) {
                    MobileMessagingLogger.e("MobileMessaging API returned error (version check)!");
                    VersionChecker.this.stats.reportError(MobileMessagingStatsError.VERSION_CHECK_ERROR);
                    VersionChecker.this.retry(versionCheckResult);
                    return;
                }
                String current = SoftwareInformation.getLibraryVersion();
                if (VersionChecker.this.shouldUpdate(versionCheckResult.getVersion(), current)) {
                    MobileMessagingLogger.w(VersionChecker.TAG, "Your library version is outdated, find latest release " + versionCheckResult.getVersion() + " here: " + versionCheckResult.getUpdateUrl());
                }
                PreferenceHelper.saveLong(VersionChecker.this.context, MobileMessagingProperty.VERSION_CHECK_LAST_TIME, System.currentTimeMillis());
            }

            protected void onCancelled(VersionCheckResult versionCheckResult) {
                MobileMessagingLogger.e("Error while checking version!");
                VersionChecker.this.stats.reportError(MobileMessagingStatsError.VERSION_CHECK_ERROR);
                VersionChecker.this.retry(versionCheckResult);
            }
        }.execute(new Void[0]);
    }

    @Override
    public Task getTask() {
        return Task.VERSION_CHECK;
    }

    private boolean shouldUpdate(String latest, String current) {
        try {
            Version latestVersion = new Version(latest);
            Version currentVersion = new Version(current);
            return latestVersion.compareTo(currentVersion) > 0;
        }
        catch (Exception e) {
            MobileMessagingLogger.w(TAG, "Cannot process versions: current(" + current + ") latest(" + latest + ") " + e);
            return false;
        }
    }
}

