/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.dal.bundle;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;
import org.infobip.mobile.messaging.geo.Geo;
import org.infobip.mobile.messaging.geo.GeoReport;

public class BundleMapper {
    private static final String BUNDLED_MESSAGE_TAG = BundleMapper.class.getName() + ".message";
    private static final String BUNDLED_GEO_TAG = BundleMapper.class.getName() + ".geo";
    private static final String BUNDLED_GEO_REPORTS_TAG = BundleMapper.class.getName() + ".geo.report";
    private static final JsonSerializer serializer = new JsonSerializer();

    @Nullable
    public static Message messageFromBundle(@NonNull Bundle bundle) {
        return BundleMapper.objectFromBundle(bundle, BUNDLED_MESSAGE_TAG, Message.class);
    }

    @NonNull
    public static List<Message> messagesFromBundles(@NonNull ArrayList<Bundle> bundles) {
        return BundleMapper.objectsFromBundles(bundles, BUNDLED_MESSAGE_TAG, Message.class);
    }

    @NonNull
    public static Bundle messageToBundle(@NonNull Message message) {
        return BundleMapper.objectToBundle(message, BUNDLED_MESSAGE_TAG);
    }

    @NonNull
    public static ArrayList<Bundle> messagesToBundles(@NonNull List<Message> messages) {
        return BundleMapper.objectsToBundles(messages, BUNDLED_MESSAGE_TAG);
    }

    @Nullable
    public static Geo geoFromBundle(@NonNull Bundle bundle) {
        return BundleMapper.objectFromBundle(bundle, BUNDLED_GEO_TAG, Geo.class);
    }

    @NonNull
    public static Bundle geoToBundle(@NonNull Geo geo) {
        return BundleMapper.objectToBundle(geo, BUNDLED_GEO_TAG);
    }

    @NonNull
    public static List<GeoReport> geoReportsFromBundle(@NonNull Bundle bundle) {
        return BundleMapper.objectsFromBundle(bundle, BUNDLED_GEO_REPORTS_TAG, GeoReport.class);
    }

    @NonNull
    public static Bundle geoReportsToBundle(@NonNull List<GeoReport> reports) {
        return BundleMapper.objectsToBundle(reports, BUNDLED_GEO_REPORTS_TAG);
    }

    @Nullable
    private static <T> T objectFromBundle(@NonNull Bundle bundle, @NonNull String tag, Class<T> cls) {
        String json = bundle.getString(tag);
        if (json == null) {
            return null;
        }
        return (T)serializer.deserialize(json, cls);
    }

    @NonNull
    private static Bundle objectToBundle(@NonNull Object object, @NonNull String tag) {
        Bundle bundle = new Bundle();
        bundle.putString(tag, serializer.serialize(object));
        return bundle;
    }

    @NonNull
    private static <T> List<T> objectsFromBundle(@NonNull Bundle bundle, @NonNull String tag, @NonNull Class<T> cls) {
        ArrayList bundles = bundle.getParcelableArrayList(tag);
        if (bundles == null) {
            return new ArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>(bundles.size());
        for (Bundle b : bundles) {
            list.add(serializer.deserialize(b.getString(tag), cls));
        }
        return list;
    }

    @NonNull
    private static Bundle objectsToBundle(@NonNull List<?> objects, @NonNull String tag) {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList(tag, BundleMapper.objectsToBundles(objects, tag));
        return bundle;
    }

    @NonNull
    private static <T> List<T> objectsFromBundles(@NonNull List<Bundle> bundles, @NonNull String tag, @NonNull Class<T> cls) {
        ArrayList<Object> objects = new ArrayList<Object>(bundles.size());
        for (Bundle bundle : bundles) {
            objects.add(serializer.deserialize(bundle.getString(tag), cls));
        }
        return objects;
    }

    @NonNull
    private static ArrayList<Bundle> objectsToBundles(@NonNull List<?> objects, @NonNull String tag) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>(objects.size());
        for (Object object : objects) {
            Bundle bundle = new Bundle();
            bundle.putString(tag, serializer.serialize(object));
            bundles.add(bundle);
        }
        return bundles;
    }
}

