/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.geo;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingLogger;
import org.infobip.mobile.messaging.geo.Area;
import org.infobip.mobile.messaging.geo.GeoEventType;
import org.infobip.mobile.messaging.geo.GeoNotificationHelper;
import org.infobip.mobile.messaging.geo.GeoReport;
import org.infobip.mobile.messaging.geo.GeoReportHelper;
import org.infobip.mobile.messaging.geo.GeoTransition;
import org.infobip.mobile.messaging.geo.GeoTransitionHelper;
import org.infobip.mobile.messaging.mobile.geo.GeoReporter;
import org.infobip.mobile.messaging.mobile.geo.GeoReportingResult;
import org.infobip.mobile.messaging.platform.Broadcaster;
import org.infobip.mobile.messaging.storage.MessageStore;

public class GeoAreasHandler {
    private static final String TAG = "GeofenceTransitions";
    private final MessageStore geoMessageStore;
    private final GeoNotificationHelper geoNotificationHelper;
    private final GeoReporter geoReporter;
    private final Context context;

    GeoAreasHandler(Context context, Broadcaster broadcaster) {
        this(context, new GeoNotificationHelper(context, broadcaster), new GeoReporter(context, broadcaster, MobileMessagingCore.getInstance(context).getStats()), MobileMessagingCore.getInstance(context).getMessageStoreForGeo());
    }

    GeoAreasHandler(Context context, GeoNotificationHelper geoNotificationHelper, GeoReporter geoReporter, MessageStore geoMessageStore) {
        this.context = context;
        this.geoNotificationHelper = geoNotificationHelper;
        this.geoReporter = geoReporter;
        this.geoMessageStore = geoMessageStore;
    }

    void handleTransition(Intent intent) {
        GeoTransition transition;
        try {
            transition = GeoTransitionHelper.resolveTransitionFromIntent(intent);
        }
        catch (GeoTransitionHelper.GeofenceNotAvailableException e) {
            MobileMessagingCore.getInstance(this.context).setAllActiveGeoAreasMonitored(false);
            MobileMessagingLogger.e(TAG, "Geofence not available");
            return;
        }
        catch (Exception e) {
            MobileMessagingLogger.e(TAG, "Cannot resolve transition information: " + e);
            return;
        }
        this.handleTransition(transition);
    }

    void handleTransition(GeoTransition transition) {
        Map<Message, List<Area>> messagesAndAreas = GeoReportHelper.findSignalingMessagesAndAreas(this.context, this.geoMessageStore, transition.getRequestIds(), transition.getEventType());
        if (messagesAndAreas.isEmpty()) {
            MobileMessagingLogger.d(TAG, "No messages for triggered areas");
            return;
        }
        GeoAreasHandler.logGeofences(messagesAndAreas.values(), transition.getEventType());
        MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance(this.context);
        mobileMessagingCore.addUnreportedGeoEvents(GeoReportHelper.createReportsForMultipleMessages(messagesAndAreas, transition.getEventType(), transition.getTriggeringLocation()));
        GeoReport[] unreportedEvents = MobileMessagingCore.getInstance(this.context).removeUnreportedGeoEvents();
        if (unreportedEvents.length == 0) {
            MobileMessagingLogger.d(TAG, "No geofencing events to report at current time");
            return;
        }
        GeoReportingResult result = this.geoReporter.reportSync(this.context, unreportedEvents);
        this.handleReportingResultWithNewMessagesAndNotifications(unreportedEvents, result);
    }

    private void handleReportingResultWithNewMessagesAndNotifications(GeoReport[] unreportedEvents, GeoReportingResult result) {
        List<GeoReport> reports = GeoReportHelper.filterOutNonActiveReports(this.context, Arrays.asList(unreportedEvents), result);
        Map<Message, GeoEventType> messages = GeoReportHelper.createMessagesToNotify(this.context, reports, result);
        this.saveMessages(messages.keySet());
        GeoAreasHandler.handleGeoReportingResult(this.context, result);
        this.geoNotificationHelper.notifyAboutGeoTransitions(messages);
    }

    private void saveMessages(Collection<Message> generatedMessages) {
        MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance(this.context);
        if (!mobileMessagingCore.isMessageStoreEnabled()) {
            return;
        }
        MessageStore messageStore = mobileMessagingCore.getMessageStore();
        messageStore.save(this.context, generatedMessages.toArray(new Message[generatedMessages.size()]));
    }

    public static void handleGeoReportingResult(Context context, @NonNull GeoReportingResult result) {
        GeoAreasHandler.updateMessageStoreWithReportingResult(context, result);
        GeoAreasHandler.updateUnreportedSeenMessageIds(context, result);
        if (!result.hasError()) {
            MobileMessagingCore.getInstance(context).sync();
        }
    }

    private static void updateMessageStoreWithReportingResult(Context context, @NonNull GeoReportingResult reportingResult) {
        if (reportingResult.getMessageIds() == null || reportingResult.getMessageIds().isEmpty()) {
            return;
        }
        MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance(context);
        if (!mobileMessagingCore.isMessageStoreEnabled()) {
            return;
        }
        MessageStore messageStore = mobileMessagingCore.getMessageStore();
        List<Message> allMessages = messageStore.findAll(context);
        Map<String, String> messageIds = reportingResult.getMessageIds();
        for (Message message : allMessages) {
            String newMessageId = messageIds.get(message.getMessageId());
            if (newMessageId == null) continue;
            message.setMessageId(newMessageId);
        }
        messageStore.deleteAll(context);
        messageStore.save(context, allMessages.toArray(new Message[allMessages.size()]));
    }

    private static void updateUnreportedSeenMessageIds(Context context, @NonNull GeoReportingResult reportingResult) {
        if (reportingResult.hasError() || reportingResult.getMessageIds() == null || reportingResult.getMessageIds().isEmpty()) {
            return;
        }
        MobileMessagingCore.getInstance(context).updateUnreportedSeenMessageIds(reportingResult.getMessageIds());
    }

    private static void logGeofences(Collection<List<Area>> collection, @NonNull GeoEventType event) {
        for (List<Area> areas : collection) {
            for (Area a : areas) {
                MobileMessagingLogger.i(TAG, event.name().toUpperCase() + " (" + a.getTitle() + ") LAT:" + a.getLatitude() + " LON:" + a.getLongitude() + " RAD:" + a.getRadius());
            }
        }
    }
}

