/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.geo;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingLogger;
import org.infobip.mobile.messaging.geo.Area;
import org.infobip.mobile.messaging.geo.Geo;
import org.infobip.mobile.messaging.geo.GeoEventType;
import org.infobip.mobile.messaging.geo.GeoLatLng;
import org.infobip.mobile.messaging.geo.GeoNotificationHelper;
import org.infobip.mobile.messaging.geo.GeoReport;
import org.infobip.mobile.messaging.mobile.geo.GeoReportingResult;
import org.infobip.mobile.messaging.platform.Time;
import org.infobip.mobile.messaging.storage.MessageStore;

public class GeoReportHelper {
    @Nullable
    public static Message getSignalingMessageForReport(List<Message> messages, GeoReport report) {
        for (Message m : messages) {
            if (!m.getMessageId().equals(report.getSignalingMessageId())) continue;
            return m;
        }
        return null;
    }

    static Map<Message, GeoEventType> createMessagesToNotify(Context context, List<GeoReport> reportedEvents, @NonNull GeoReportingResult reportingResult) {
        List<Message> allMessages = MobileMessagingCore.getInstance(context).getMessageStoreForGeo().findAll(context);
        HashMap<Message, GeoEventType> messages = new HashMap<Message, GeoEventType>();
        for (GeoReport report : reportedEvents) {
            Message signalingMessage = GeoReportHelper.getSignalingMessageForReport(allMessages, report);
            if (signalingMessage == null) {
                MobileMessagingLogger.e("Cannot find signaling message for id: " + report.getSignalingMessageId());
                continue;
            }
            messages.put(GeoReportHelper.createNewMessageForReport(report, reportingResult, signalingMessage), report.getEvent());
        }
        return messages;
    }

    static GeoReport[] createReportsForMultipleMessages(Map<Message, List<Area>> messagesAndAreas, @NonNull GeoEventType event, @NonNull GeoLatLng triggeringLocation) {
        ArrayList<GeoReport> reports = new ArrayList<GeoReport>();
        for (Message message : messagesAndAreas.keySet()) {
            reports.addAll(GeoReportHelper.createReports(message, messagesAndAreas.get(message), event, triggeringLocation));
        }
        return reports.toArray(new GeoReport[reports.size()]);
    }

    private static Set<GeoReport> createReports(Message signalingMessage, List<Area> areas, @NonNull GeoEventType event, @NonNull GeoLatLng triggeringLocation) {
        HashSet<GeoReport> reports = new HashSet<GeoReport>();
        for (Area area : areas) {
            reports.add(GeoReportHelper.createReport(signalingMessage, area, event, triggeringLocation));
        }
        return reports;
    }

    @NonNull
    private static GeoReport createReport(Message signalingMessage, Area area, @NonNull GeoEventType event, @NonNull GeoLatLng triggeringLocation) {
        return new GeoReport(signalingMessage.getGeo().getCampaignId(), UUID.randomUUID().toString(), signalingMessage.getMessageId(), event, area, Time.now(), triggeringLocation);
    }

    private static Message createNewMessageForReport(@NonNull GeoReport report, @NonNull GeoReportingResult reportingResult, @NonNull Message originalMessage) {
        GeoLatLng triggeringLocation = report.getTriggeringLocation();
        if (triggeringLocation == null) {
            triggeringLocation = new GeoLatLng(null, null);
        }
        ArrayList<Area> areas = new ArrayList<Area>();
        if (report.getArea() != null) {
            areas.add(report.getArea());
        }
        Geo geo = originalMessage.getGeo() != null ? new Geo(triggeringLocation.getLat(), triggeringLocation.getLng(), originalMessage.getGeo().getDeliveryTime(), originalMessage.getGeo().getExpiryTime(), originalMessage.getGeo().getStartTime(), originalMessage.getGeo().getCampaignId(), areas, originalMessage.getGeo().getEvents()) : new Geo(triggeringLocation.getLat(), triggeringLocation.getLng(), null, null, null, null, areas, null);
        return new Message(GeoReportHelper.getMessageIdFromReport(report, reportingResult), originalMessage.getTitle(), originalMessage.getBody(), originalMessage.getSound(), originalMessage.isVibrate(), originalMessage.getIcon(), false, originalMessage.getCategory(), originalMessage.getFrom(), Time.now(), 0L, originalMessage.getCustomPayload(), geo, originalMessage.getDestination(), originalMessage.getStatus(), originalMessage.getStatusMessage());
    }

    private static String getMessageIdFromReport(@NonNull GeoReport report, @NonNull GeoReportingResult reportingResult) {
        if (reportingResult.getMessageIds() == null || reportingResult.getMessageIds().isEmpty()) {
            return report.getMessageId();
        }
        String newMessageId = reportingResult.getMessageIds().get(report.getMessageId());
        if (newMessageId == null) {
            return report.getMessageId();
        }
        return newMessageId;
    }

    public static Set<String> getAndUpdateInactiveCampaigns(MobileMessagingCore mobileMessagingCore, GeoReportingResult result) {
        HashSet<String> inactiveCampaigns = new HashSet<String>();
        if (result == null || result.hasError()) {
            inactiveCampaigns.addAll(mobileMessagingCore.getSuspendedCampaignIds());
            inactiveCampaigns.addAll(mobileMessagingCore.getFinishedCampaignIds());
            return inactiveCampaigns;
        }
        mobileMessagingCore.addCampaignStatus(result.getFinishedCampaignIds(), result.getSuspendedCampaignIds());
        if (result.getFinishedCampaignIds() != null) {
            inactiveCampaigns.addAll(result.getFinishedCampaignIds());
        }
        if (result.getSuspendedCampaignIds() != null) {
            inactiveCampaigns.addAll(result.getSuspendedCampaignIds());
        }
        return inactiveCampaigns;
    }

    @NonNull
    static Map<Message, List<Area>> findSignalingMessagesAndAreas(Context context, MessageStore messageStore, Set<String> requestIds, @NonNull GeoEventType event) {
        Date now = Time.date();
        HashMap<Message, List<Area>> messagesAndAreas = new HashMap<Message, List<Area>>();
        for (Message message : messageStore.findAll(context)) {
            Date startDate;
            Geo geo = message.getGeo();
            if (geo == null || geo.getAreasList() == null || geo.getAreasList().isEmpty() || (startDate = geo.getStartDate()) != null && startDate.after(now)) continue;
            List<Area> campaignAreas = geo.getAreasList();
            ArrayList<Area> triggeredAreas = new ArrayList<Area>();
            for (Area area : campaignAreas) {
                for (String requestId : requestIds) {
                    if (!requestId.equalsIgnoreCase(area.getId()) || !GeoNotificationHelper.shouldReportTransition(context, message, event)) continue;
                    triggeredAreas.add(area);
                }
            }
            if (triggeredAreas.isEmpty()) continue;
            messagesAndAreas.put(message, triggeredAreas);
        }
        return GeoReportHelper.filterOverlappingAreas(messagesAndAreas);
    }

    public static List<GeoReport> filterOutNonActiveReports(Context context, @NonNull List<GeoReport> reports, @NonNull GeoReportingResult result) {
        if (result.hasError()) {
            return reports;
        }
        Set<String> inactiveCampaigns = GeoReportHelper.getAndUpdateInactiveCampaigns(MobileMessagingCore.getInstance(context), result);
        if (inactiveCampaigns.isEmpty()) {
            return reports;
        }
        ArrayList<GeoReport> activeReports = new ArrayList<GeoReport>();
        for (GeoReport r : reports) {
            if (inactiveCampaigns.contains(r.getCampaignId())) continue;
            activeReports.add(r);
        }
        return activeReports;
    }

    private static Map<Message, List<Area>> filterOverlappingAreas(Map<Message, List<Area>> messagesAndAreas) {
        HashMap<Message, List<Area>> filteredMessagesAndAreas = new HashMap<Message, List<Area>>(messagesAndAreas.size());
        for (Message message : messagesAndAreas.keySet()) {
            List<Area> areasList = message.getGeo().getAreasList();
            if (areasList == null) continue;
            Collections.sort(areasList, new GeoAreaRadiusComparator());
            filteredMessagesAndAreas.put(message, Collections.singletonList(areasList.get(0)));
        }
        return filteredMessagesAndAreas;
    }

    static class GeoAreaRadiusComparator
    implements Comparator<Area> {
        GeoAreaRadiusComparator() {
        }

        @Override
        public int compare(Area area1, Area area2) {
            return area1.getRadius() - area2.getRadius();
        }
    }
}

