/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile;

import android.content.Context;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.api.data.MobileApiData;
import org.infobip.mobile.messaging.api.geo.MobileApiGeo;
import org.infobip.mobile.messaging.api.messages.MobileApiMessages;
import org.infobip.mobile.messaging.api.registration.MobileApiRegistration;
import org.infobip.mobile.messaging.api.support.Generator;
import org.infobip.mobile.messaging.api.version.MobileApiVersion;
import org.infobip.mobile.messaging.app.ActivityLifecycleMonitor;
import org.infobip.mobile.messaging.util.DeviceInformation;
import org.infobip.mobile.messaging.util.MobileNetworkInformation;
import org.infobip.mobile.messaging.util.PreferenceHelper;
import org.infobip.mobile.messaging.util.SoftwareInformation;
import org.infobip.mobile.messaging.util.SystemInformation;

public enum MobileApiResourceProvider {
    INSTANCE;

    private static final ForegroundStateProvider foregroundStateProvider;
    private Generator generator;
    private MobileApiRegistration mobileApiRegistration;
    private MobileApiMessages mobileApiMessages;
    private MobileApiData mobileApiData;
    private MobileApiVersion mobileApiVersion;
    private MobileApiGeo mobileApiGeo;

    public MobileApiRegistration getMobileApiRegistration(Context context) {
        if (null != this.mobileApiRegistration) {
            return this.mobileApiRegistration;
        }
        this.mobileApiRegistration = (MobileApiRegistration)this.getGenerator(context).create(MobileApiRegistration.class);
        return this.mobileApiRegistration;
    }

    public MobileApiMessages getMobileApiMessages(Context context) {
        if (null != this.mobileApiMessages) {
            return this.mobileApiMessages;
        }
        this.mobileApiMessages = (MobileApiMessages)this.getGenerator(context).create(MobileApiMessages.class);
        return this.mobileApiMessages;
    }

    public MobileApiData getMobileApiData(Context context) {
        if (null != this.mobileApiData) {
            return this.mobileApiData;
        }
        this.mobileApiData = (MobileApiData)this.getGenerator(context).create(MobileApiData.class);
        return this.mobileApiData;
    }

    public MobileApiVersion getMobileApiVersion(Context context) {
        if (null != this.mobileApiVersion) {
            return this.mobileApiVersion;
        }
        this.mobileApiVersion = (MobileApiVersion)this.getGenerator(context).create(MobileApiVersion.class);
        return this.mobileApiVersion;
    }

    public MobileApiGeo getMobileApiGeo(Context context) {
        if (null != this.mobileApiGeo) {
            return this.mobileApiGeo;
        }
        this.mobileApiGeo = (MobileApiGeo)this.getGenerator(context).create(MobileApiGeo.class);
        return this.mobileApiGeo;
    }

    String[] getUserAgentAdditions(Context context) {
        ArrayList<String> userAgentAdditions = new ArrayList<String>();
        if (PreferenceHelper.findBoolean(context, MobileMessagingProperty.REPORT_SYSTEM_INFO)) {
            userAgentAdditions.add(SystemInformation.getAndroidSystemName());
            userAgentAdditions.add(SystemInformation.getAndroidSystemVersion());
            userAgentAdditions.add(SystemInformation.getAndroidSystemABI());
            userAgentAdditions.add(DeviceInformation.getDeviceModel());
            userAgentAdditions.add(DeviceInformation.getDeviceManufacturer());
            userAgentAdditions.add(SoftwareInformation.getAppName(context));
            userAgentAdditions.add(SoftwareInformation.getAppVersion(context));
        } else {
            String[] emptySystemInfo = new String[]{"", "", "", "", "", "", ""};
            userAgentAdditions.addAll(Arrays.asList(emptySystemInfo));
        }
        if (PreferenceHelper.findBoolean(context, MobileMessagingProperty.REPORT_CARRIER_INFO)) {
            userAgentAdditions.add(MobileNetworkInformation.getMobileCarrierName(context));
            userAgentAdditions.add(MobileNetworkInformation.getMobileNetworkCode(context));
            userAgentAdditions.add(MobileNetworkInformation.getMobileCoutryCode(context));
            userAgentAdditions.add(MobileNetworkInformation.getSIMCarrierName(context));
            userAgentAdditions.add(MobileNetworkInformation.getSIMNetworkCode(context));
            userAgentAdditions.add(MobileNetworkInformation.getSIMCoutryCode(context));
        } else {
            String[] emptyCarrierInfoAdditions = new String[]{"", "", "", "", "", ""};
            userAgentAdditions.addAll(Arrays.asList(emptyCarrierInfoAdditions));
        }
        return userAgentAdditions.toArray(new String[userAgentAdditions.size()]);
    }

    private Generator getGenerator(Context context) {
        if (null != this.generator) {
            return this.generator;
        }
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)System.getProperties());
        properties.put("api.key", MobileMessagingCore.getApplicationCode(context));
        properties.put("library.version", SoftwareInformation.getLibraryVersion());
        this.generator = new Generator.Builder().withBaseUrl(MobileMessagingCore.getInstance(context).getApiUri()).withProperties(properties).withUserAgentAdditions(this.getUserAgentAdditions(context)).withDynamicHeaderProvider((Generator.CommonHeaderProvider)foregroundStateProvider).build();
        return this.generator;
    }

    public void resetMobileApi() {
        this.generator = null;
        this.mobileApiRegistration = null;
        this.mobileApiMessages = null;
        this.mobileApiData = null;
        this.mobileApiVersion = null;
        this.mobileApiGeo = null;
    }

    static {
        foregroundStateProvider = new ForegroundStateProvider();
    }

    public static class ForegroundStateProvider
    implements Generator.CommonHeaderProvider {
        public Map<String, Collection<Object>> get() {
            return new HashMap<String, Collection<Object>>(){
                {
                    this.put("foreground", Collections.singletonList(ActivityLifecycleMonitor.isForeground()));
                }
            };
        }
    }
}

