/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.geo;

import android.content.Context;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingLogger;
import org.infobip.mobile.messaging.api.geo.EventReport;
import org.infobip.mobile.messaging.api.geo.EventReportBody;
import org.infobip.mobile.messaging.api.geo.EventReportResponse;
import org.infobip.mobile.messaging.api.geo.EventType;
import org.infobip.mobile.messaging.api.geo.MessagePayload;
import org.infobip.mobile.messaging.dal.json.InternalDataMapper;
import org.infobip.mobile.messaging.geo.GeoReport;
import org.infobip.mobile.messaging.geo.GeoReportHelper;
import org.infobip.mobile.messaging.mobile.MobileApiResourceProvider;
import org.infobip.mobile.messaging.mobile.geo.GeoReportingResult;
import org.infobip.mobile.messaging.platform.Time;
import org.infobip.mobile.messaging.storage.MessageStore;

class GeoReportingTask
extends AsyncTask<GeoReport, Void, GeoReportingResult> {
    private final Context context;

    GeoReportingTask(Context context) {
        this.context = context;
    }

    @NonNull
    static GeoReportingResult executeSync(Context context, GeoReport[] geoReports) throws RuntimeException {
        EventReportBody eventReportBody = GeoReportingTask.prepareEventReportBody(context, geoReports);
        EventReportResponse eventResponse = MobileApiResourceProvider.INSTANCE.getMobileApiGeo(context).report(eventReportBody);
        return new GeoReportingResult(eventResponse);
    }

    protected GeoReportingResult doInBackground(GeoReport[] geoReports) {
        if (geoReports.length < 1) {
            return new GeoReportingResult(new IllegalArgumentException("No geo reports to send"));
        }
        try {
            return GeoReportingTask.executeSync(this.context, geoReports);
        }
        catch (Exception e) {
            MobileMessagingCore.getInstance(this.context).setLastHttpException(e);
            MobileMessagingLogger.e("Error reporting geo areas!", e);
            this.cancel(true);
            return new GeoReportingResult(e);
        }
    }

    @NonNull
    private static EventReportBody prepareEventReportBody(Context context, @NonNull GeoReport[] geoReports) {
        HashSet<MessagePayload> messagePayloads = new HashSet<MessagePayload>();
        HashSet<EventReport> eventReports = new HashSet<EventReport>();
        MessageStore store = MobileMessagingCore.getInstance(context).getMessageStoreForGeo();
        List<Message> messages = store.findAll(context);
        for (GeoReport r : geoReports) {
            Message m = GeoReportHelper.getSignalingMessageForReport(messages, r);
            if (m == null) {
                MobileMessagingLogger.e("Cannot find signaling message for id: " + r.getSignalingMessageId());
                continue;
            }
            messagePayloads.add(new MessagePayload(m.getMessageId(), m.getTitle(), m.getBody(), m.getSound(), Boolean.valueOf(m.isVibrate()), m.getCategory(), Boolean.valueOf(m.isSilent()), m.getCustomPayload() != null ? m.getCustomPayload().toString() : null, InternalDataMapper.createInternalDataBasedOnMessageContents(m)));
            Long timestampDelta = Time.now() - r.getTimestampOccurred();
            Long timestampDeltaSeconds = TimeUnit.MILLISECONDS.toSeconds(timestampDelta);
            eventReports.add(new EventReport(EventType.valueOf((String)r.getEvent().name()), r.getArea().getId(), r.getCampaignId(), r.getSignalingMessageId(), r.getMessageId(), timestampDeltaSeconds));
        }
        String deviceInstanceId = MobileMessagingCore.getInstance(context).getDeviceApplicationInstanceId();
        return new EventReportBody(messagePayloads, eventReports, deviceInstanceId);
    }
}

