/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.seen;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.AsyncTask;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingLogger;
import org.infobip.mobile.messaging.api.messages.SeenMessages;
import org.infobip.mobile.messaging.mobile.InternalSdkError;
import org.infobip.mobile.messaging.mobile.MobileApiResourceProvider;
import org.infobip.mobile.messaging.mobile.seen.SeenMessagesReport;
import org.infobip.mobile.messaging.mobile.seen.SeenStatusReportResult;
import org.infobip.mobile.messaging.util.StringUtils;

@TargetApi(value=14)
class SeenStatusReportTask
extends AsyncTask<Object, Void, SeenStatusReportResult> {
    private final Context context;

    SeenStatusReportTask(Context context) {
        this.context = context;
    }

    protected SeenStatusReportResult doInBackground(Object ... notUsed) {
        MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance(this.context);
        String deviceApplicationInstanceId = mobileMessagingCore.getDeviceApplicationInstanceId();
        if (StringUtils.isBlank(deviceApplicationInstanceId)) {
            MobileMessagingLogger.e(InternalSdkError.NO_VALID_REGISTRATION.get());
            return new SeenStatusReportResult(InternalSdkError.NO_VALID_REGISTRATION.getException());
        }
        try {
            String[] messageIDs = mobileMessagingCore.getUnreportedSeenMessageIds();
            SeenMessages seenMessages = SeenMessagesReport.fromMessageIds(messageIDs);
            MobileApiResourceProvider.INSTANCE.getMobileApiMessages(this.context).reportSeen(seenMessages);
            mobileMessagingCore.removeUnreportedSeenMessageIds(messageIDs);
            return new SeenStatusReportResult(messageIDs);
        }
        catch (Exception e) {
            mobileMessagingCore.setLastHttpException(e);
            MobileMessagingLogger.e("Error reporting seen status!", e);
            this.cancel(true);
            return new SeenStatusReportResult(e);
        }
    }
}

