/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.notification;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingLogger;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.NotificationSettings;
import org.infobip.mobile.messaging.platform.AndroidBroadcaster;
import org.infobip.mobile.messaging.platform.Broadcaster;

public class NotificationTapReceiver
extends BroadcastReceiver {
    private Broadcaster broadcaster;
    private MobileMessagingCore mobileMessagingCore;

    public NotificationTapReceiver() {
    }

    public NotificationTapReceiver(Broadcaster broadcaster, MobileMessagingCore mobileMessagingCore) {
        this.broadcaster = broadcaster;
        this.mobileMessagingCore = mobileMessagingCore;
    }

    public void onReceive(Context context, Intent intent) {
        Class<?> callbackActivity;
        Bundle messageBundle = intent.getBundleExtra("org.infobip.mobile.messaging.message");
        Message message = Message.createFrom(messageBundle);
        if (message == null) {
            MobileMessagingLogger.e("Received no message in NotificationTapReceiver");
            return;
        }
        this.broadcaster(context).notificationTapped(message);
        NotificationSettings notificationSettings = this.mobileMessagingCore(context).getNotificationSettings();
        if (notificationSettings == null) {
            return;
        }
        if (notificationSettings.markSeenOnTap()) {
            this.mobileMessagingCore(context).setMessagesSeen(message.getMessageId());
        }
        if ((callbackActivity = notificationSettings.getCallbackActivity()) == null) {
            MobileMessagingLogger.e("Callback activity is not set, cannot proceed");
            return;
        }
        int intentFlags = intent.getIntExtra(MobileMessagingProperty.EXTRA_INTENT_FLAGS.getKey(), ((Integer)MobileMessagingProperty.INTENT_FLAGS.getDefaultValue()).intValue());
        Intent callbackIntent = new Intent(context, callbackActivity);
        callbackIntent.putExtra("org.infobip.mobile.messaging.message", messageBundle);
        callbackIntent.addFlags(intentFlags | 0x10000000);
        context.startActivity(callbackIntent);
    }

    private Broadcaster broadcaster(Context context) {
        if (this.broadcaster == null) {
            this.broadcaster = new AndroidBroadcaster(context);
        }
        return this.broadcaster;
    }

    private MobileMessagingCore mobileMessagingCore(Context context) {
        if (this.mobileMessagingCore == null) {
            this.mobileMessagingCore = MobileMessagingCore.getInstance(context);
        }
        return this.mobileMessagingCore;
    }
}

