/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.util;

import android.os.Build;
import android.util.Log;
import java.lang.reflect.Field;
import org.infobip.mobile.messaging.MobileMessagingLogger;

public class SystemInformation {
    private static String systemName = null;
    private static String androidABI = null;

    private SystemInformation() {
    }

    public static String getAndroidSystemName() {
        Field[] fields;
        if (systemName != null) {
            return systemName;
        }
        for (Field field : fields = Build.VERSION_CODES.class.getFields()) {
            String fieldName = field.getName();
            int fieldValue = -1;
            try {
                fieldValue = field.getInt(new Object());
            }
            catch (IllegalAccessException | IllegalArgumentException | NullPointerException e) {
                MobileMessagingLogger.d(Log.getStackTraceString((Throwable)e));
            }
            if (fieldValue != Build.VERSION.SDK_INT) continue;
            systemName = fieldName;
        }
        return systemName;
    }

    public static String getAndroidSystemABI() {
        if (androidABI != null) {
            return androidABI;
        }
        androidABI = Build.VERSION.SDK_INT < 21 ? Build.CPU_ABI : Build.SUPPORTED_ABIS[0];
        return androidABI;
    }

    public static String getAndroidSystemVersion() {
        return Build.VERSION.RELEASE;
    }
}

