/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.dal.bundle;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;

public abstract class BundleMapper {
    protected static final JsonSerializer serializer = new JsonSerializer();

    @Nullable
    protected static <T> T objectFromBundle(@NonNull Bundle bundle, @NonNull String tag, Class<T> cls) {
        String json = bundle.getString(tag);
        if (json == null) {
            return null;
        }
        return (T)serializer.deserialize(json, cls);
    }

    @NonNull
    protected static Bundle objectToBundle(@NonNull Object object, @NonNull String tag) {
        Bundle bundle = new Bundle();
        bundle.putString(tag, serializer.serialize(object));
        return bundle;
    }

    @NonNull
    protected static <T> List<T> objectsFromBundle(@NonNull Bundle bundle, @NonNull String tag, @NonNull Class<T> cls) {
        ArrayList bundles = bundle.getParcelableArrayList(tag);
        if (bundles == null) {
            return new ArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>(bundles.size());
        for (Bundle b : bundles) {
            list.add(serializer.deserialize(b.getString(tag), cls));
        }
        return list;
    }

    @NonNull
    protected static Bundle objectsToBundle(@NonNull List<?> objects, @NonNull String tag) {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList(tag, BundleMapper.objectsToBundles(objects, tag));
        return bundle;
    }

    @NonNull
    protected static <T> List<T> objectsFromBundles(@NonNull List<Bundle> bundles, @NonNull String tag, @NonNull Class<T> cls) {
        ArrayList<Object> objects = new ArrayList<Object>(bundles.size());
        for (Bundle bundle : bundles) {
            objects.add(serializer.deserialize(bundle.getString(tag), cls));
        }
        return objects;
    }

    @NonNull
    protected static ArrayList<Bundle> objectsToBundles(@NonNull List<?> objects, @NonNull String tag) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>(objects.size());
        for (Object object : objects) {
            Bundle bundle = new Bundle();
            bundle.putString(tag, serializer.serialize(object));
            bundles.add(bundle);
        }
        return bundles;
    }
}

