/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile;

import android.util.Log;
import java.io.Serializable;
import java.util.Locale;
import org.infobip.mobile.messaging.api.support.ApiIOException;

public class MobileMessagingError
implements Serializable {
    private final String code;
    private final String message;
    private final Type type;
    private final Throwable tr;

    public static MobileMessagingError createFrom(Throwable e) {
        return new MobileMessagingError(e);
    }

    public MobileMessagingError(String code, String message) {
        this.code = code;
        this.message = message;
        this.type = Type.SDK_ERROR;
        this.tr = new Throwable(message);
    }

    public MobileMessagingError(String code, String message, Throwable tr) {
        this.code = code;
        this.message = message;
        this.type = Type.SDK_ERROR;
        this.tr = tr;
    }

    private MobileMessagingError(Throwable e) {
        if (e != null && e instanceof ApiIOException) {
            ApiIOException apiIOException = (ApiIOException)e;
            this.code = apiIOException.getCode();
            this.message = apiIOException.getMessage();
            this.type = Type.SERVER_ERROR;
            this.tr = new Throwable(this.message);
        } else {
            this.code = "-10";
            this.message = e != null ? e.getMessage() : "Something went wrong";
            this.type = Type.UNKNOWN_ERROR;
            this.tr = new Throwable(this.message);
        }
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Type getType() {
        return this.type;
    }

    public String getStacktrace() {
        return this.tr != null ? Log.getStackTraceString((Throwable)this.tr) : null;
    }

    public String toString() {
        return String.format(Locale.getDefault(), "%s, %s, %s", this.type.name(), this.code, this.message);
    }

    public static enum Type {
        UNKNOWN_ERROR,
        SDK_ERROR,
        SERVER_ERROR;

    }
}

