/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.messages;

import android.content.Context;
import java.util.List;
import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingLogger;
import org.infobip.mobile.messaging.gcm.MobileMessageHandler;
import org.infobip.mobile.messaging.mobile.MobileMessagingError;
import org.infobip.mobile.messaging.mobile.messages.SyncMessagesResult;
import org.infobip.mobile.messaging.mobile.messages.SyncMessagesTask;
import org.infobip.mobile.messaging.mobile.synchronizer.RetryableSynchronizer;
import org.infobip.mobile.messaging.mobile.synchronizer.Task;
import org.infobip.mobile.messaging.notification.NotificationHandler;
import org.infobip.mobile.messaging.platform.Broadcaster;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.stats.MobileMessagingStatsError;

public class MessagesSynchronizer
extends RetryableSynchronizer {
    private final Broadcaster broadcaster;
    private final MobileMessageHandler mobileMessageHandler;

    public MessagesSynchronizer(Context context, MobileMessagingStats stats, Executor executor, Broadcaster broadcaster, NotificationHandler notificationHandler) {
        super(context, stats, executor);
        this.broadcaster = broadcaster;
        this.mobileMessageHandler = new MobileMessageHandler(broadcaster, notificationHandler);
    }

    @Override
    public void synchronize() {
        new SyncMessagesTask(this.context, this.broadcaster){

            protected void onPostExecute(SyncMessagesResult syncMessagesResult) {
                if (syncMessagesResult.hasError()) {
                    MobileMessagingLogger.e("MobileMessaging API returned error (synchronizing messages)!");
                    MessagesSynchronizer.this.stats.reportError(MobileMessagingStatsError.SYNC_MESSAGES_ERROR);
                    MessagesSynchronizer.this.broadcaster.error(MobileMessagingError.createFrom(syncMessagesResult.getError()));
                    MessagesSynchronizer.this.retry(syncMessagesResult);
                    return;
                }
                List<Message> messages = syncMessagesResult.getMessages();
                if (messages == null) {
                    return;
                }
                for (Message message : messages) {
                    MessagesSynchronizer.this.mobileMessageHandler.handleMessage(MessagesSynchronizer.this.context, message);
                }
            }

            protected void onCancelled(SyncMessagesResult result) {
                MobileMessagingLogger.e("Error syncing messages!");
                MessagesSynchronizer.this.stats.reportError(MobileMessagingStatsError.SYNC_MESSAGES_ERROR);
                MessagesSynchronizer.this.broadcaster.error(MobileMessagingError.createFrom(result.getError()));
                MessagesSynchronizer.this.retry(result);
            }
        }.executeOnExecutor(this.executor, new Object[0]);
    }

    @Override
    public Task getTask() {
        return Task.SYNC_MESSAGES;
    }
}

