/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.storage;

import android.content.Context;
import java.util.ArrayList;
import java.util.List;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.dal.sqlite.DatabaseHelper;
import org.infobip.mobile.messaging.dal.sqlite.SqliteMessage;
import org.infobip.mobile.messaging.storage.MessageStore;

public class SQLiteMessageStore
implements MessageStore {
    @Override
    public void save(Context context, Message ... messages) {
        DatabaseHelper helper = MobileMessagingCore.getDatabaseHelper(context);
        for (Message message : messages) {
            helper.save(new SqliteMessage(message));
        }
    }

    @Override
    public List<Message> findAll(Context context) {
        return new ArrayList<Message>(MobileMessagingCore.getDatabaseHelper(context).findAll(SqliteMessage.class));
    }

    public Message findById(Context context, String messageId) {
        return MobileMessagingCore.getDatabaseHelper(context).find(SqliteMessage.class, messageId);
    }

    @Override
    public long countAll(Context context) {
        return MobileMessagingCore.getDatabaseHelper(context).countAll(SqliteMessage.class);
    }

    @Override
    public void deleteAll(Context context) {
        MobileMessagingCore.getDatabaseHelper(context).deleteAll(SqliteMessage.class);
    }

    public void deleteById(Context context, String messageId) {
        MobileMessagingCore.getDatabaseHelper(context).delete(SqliteMessage.class, messageId);
    }
}

