/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import java.security.InvalidParameterException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.infobip.mobile.messaging.util.DateTimeUtil;
import org.infobip.mobile.messaging.util.ISO8601DateParseException;

public class CustomUserDataValue {
    private Object value;
    private Type type;

    public CustomUserDataValue(String someString) {
        this.value = someString;
        this.type = Type.String;
    }

    public CustomUserDataValue(Number someNumber) {
        this.value = someNumber;
        this.type = Type.Number;
    }

    public CustomUserDataValue(Date someDate) {
        this.value = DateTimeUtil.ISO8601DateToString(someDate);
        this.type = Type.Date;
    }

    public CustomUserDataValue(String stringValue, Type type) throws ParseException, InvalidParameterException {
        this.type = type;
        switch (type) {
            case String: {
                this.value = stringValue;
                break;
            }
            case Number: {
                this.value = NumberFormat.getNumberInstance(Locale.getDefault()).parse(stringValue);
                break;
            }
            case Date: {
                DateTimeUtil.DateFromYMDString(stringValue);
                this.value = stringValue;
                break;
            }
            default: {
                throw new InvalidParameterException();
            }
        }
    }

    protected CustomUserDataValue(CustomUserDataValue that) {
        this.value = that.value;
        this.type = that.type;
    }

    public String stringValue() {
        if (!(this.value instanceof String) || this.type != Type.String) {
            throw new ClassCastException();
        }
        return (String)this.value;
    }

    public Number numberValue() {
        if (!(this.value instanceof Number) || this.type != Type.Number) {
            throw new ClassCastException();
        }
        return (Number)this.value;
    }

    public Date dateValue() {
        if (!(this.value instanceof String) || this.type != Type.Date) {
            throw new ClassCastException();
        }
        try {
            return DateTimeUtil.ISO8601DateFromString((String)this.value);
        }
        catch (ISO8601DateParseException e) {
            throw new ClassCastException(e.getMessage());
        }
    }

    public Type getType() {
        return this.type;
    }

    protected Object getValue() {
        return this.value;
    }

    public String toString() {
        if (this.type == null) {
            return super.toString();
        }
        switch (this.type) {
            case String: {
                return this.stringValue();
            }
            case Date: {
                return DateTimeUtil.DateToYMDString(this.dateValue());
            }
            case Number: {
                return "" + this.numberValue();
            }
        }
        return super.toString();
    }

    public static enum Type {
        String,
        Number,
        Date;

    }
}

