/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.Nullable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.infobip.mobile.messaging.ApplicationCodeProvider;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MessageStoreInstantiationException;
import org.infobip.mobile.messaging.MobileMessaging;
import org.infobip.mobile.messaging.MobileMessagingLogger;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.NotificationSettings;
import org.infobip.mobile.messaging.SystemData;
import org.infobip.mobile.messaging.UserData;
import org.infobip.mobile.messaging.app.ActivityLifecycleMonitor;
import org.infobip.mobile.messaging.dal.sqlite.DatabaseHelper;
import org.infobip.mobile.messaging.dal.sqlite.DatabaseHelperImpl;
import org.infobip.mobile.messaging.dal.sqlite.SqliteDatabaseProvider;
import org.infobip.mobile.messaging.gcm.MobileMessagingGcmIntentService;
import org.infobip.mobile.messaging.gcm.PlayServicesSupport;
import org.infobip.mobile.messaging.mobile.data.SystemDataReporter;
import org.infobip.mobile.messaging.mobile.data.UserDataSynchronizer;
import org.infobip.mobile.messaging.mobile.messages.MessageSender;
import org.infobip.mobile.messaging.mobile.messages.MessagesSynchronizer;
import org.infobip.mobile.messaging.mobile.registration.RegistrationSynchronizer;
import org.infobip.mobile.messaging.mobile.seen.SeenStatusReporter;
import org.infobip.mobile.messaging.mobile.version.VersionChecker;
import org.infobip.mobile.messaging.platform.AndroidBroadcaster;
import org.infobip.mobile.messaging.platform.Broadcaster;
import org.infobip.mobile.messaging.platform.Time;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.storage.MessageStore;
import org.infobip.mobile.messaging.telephony.MobileNetworkStateListener;
import org.infobip.mobile.messaging.util.DeviceInformation;
import org.infobip.mobile.messaging.util.ExceptionUtils;
import org.infobip.mobile.messaging.util.PreferenceHelper;
import org.infobip.mobile.messaging.util.SoftwareInformation;
import org.infobip.mobile.messaging.util.StringUtils;
import org.infobip.mobile.messaging.util.SystemInformation;
import org.json.JSONException;
import org.json.JSONObject;

public class MobileMessagingCore
extends MobileMessaging {
    private static final int MESSAGE_ID_PARAMETER_LIMIT = 100;
    private static final long MESSAGE_EXPIRY_TIME = TimeUnit.DAYS.toMillis(7L);
    protected static MobileMessagingCore instance;
    static String applicationCode;
    static ApplicationCodeProvider applicationCodeProvider;
    private static DatabaseHelper databaseHelper;
    private final RegistrationSynchronizer registrationSynchronizer;
    private final MessagesSynchronizer messagesSynchronizer;
    private final SeenStatusReporter seenStatusReporter;
    private final UserDataSynchronizer userDataSynchronizer;
    private final MessageSender messageSender;
    private final SystemDataReporter systemDataReporter;
    private final VersionChecker versionChecker;
    private final MobileMessagingStats stats;
    private final ExecutorService registrationAlignedExecutor;
    private ActivityLifecycleMonitor activityLifecycleMonitor;
    private MobileNetworkStateListener mobileNetworkStateListener;
    private PlayServicesSupport playServicesSupport;
    private NotificationSettings notificationSettings;
    private MessageStore messageStore;
    private Context context;

    protected MobileMessagingCore(Context context) {
        this(context, new AndroidBroadcaster(context), Executors.newSingleThreadExecutor());
    }

    protected MobileMessagingCore(Context context, Broadcaster broadcaster, ExecutorService registrationAlignedExecutor) {
        MobileMessagingLogger.init(context);
        this.context = context;
        this.registrationAlignedExecutor = registrationAlignedExecutor;
        this.stats = new MobileMessagingStats(context);
        this.messageSender = new MessageSender(broadcaster);
        this.messagesSynchronizer = new MessagesSynchronizer(context, this.stats, registrationAlignedExecutor, broadcaster);
        this.seenStatusReporter = new SeenStatusReporter(context, this.stats, registrationAlignedExecutor, broadcaster);
        this.userDataSynchronizer = new UserDataSynchronizer(context, this, registrationAlignedExecutor, broadcaster);
        this.systemDataReporter = new SystemDataReporter(context, this.stats, registrationAlignedExecutor, broadcaster);
        this.versionChecker = new VersionChecker(context, this.stats);
        this.registrationSynchronizer = new RegistrationSynchronizer(context, this.stats, registrationAlignedExecutor, broadcaster);
    }

    public static MobileMessagingCore getInstance(Context context) {
        if (null != instance) {
            return instance;
        }
        return new MobileMessagingCore(context);
    }

    public static DatabaseHelper getDatabaseHelper(Context context) {
        if (null == databaseHelper) {
            databaseHelper = new DatabaseHelperImpl(context);
        }
        return databaseHelper;
    }

    public static SqliteDatabaseProvider getDatabaseProvider(Context context) {
        return (SqliteDatabaseProvider)((Object)MobileMessagingCore.getDatabaseHelper(context));
    }

    public void sync() {
        this.registrationSynchronizer.synchronize();
        this.userDataSynchronizer.synchronize((MobileMessaging.ResultListener)null, this.getUnreportedUserData());
        this.seenStatusReporter.synchronize();
        this.versionChecker.synchronize();
        this.reportSystemData();
        if (this.isPushRegistrationEnabled()) {
            this.messagesSynchronizer.synchronize();
        }
    }

    @Override
    public void enablePushRegistration() {
        PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.PUSH_REGISTRATION_ENABLED, true);
        this.registrationSynchronizer.updatePushRegistrationStatus(true);
    }

    @Override
    public void disablePushRegistration() {
        PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.PUSH_REGISTRATION_ENABLED, false);
        this.registrationSynchronizer.updatePushRegistrationStatus(false);
    }

    @Override
    public boolean isPushRegistrationEnabled() {
        return PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.PUSH_REGISTRATION_ENABLED);
    }

    public String getRegistrationId() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.GCM_REGISTRATION_ID);
    }

    public void setRegistrationId(String registrationId) {
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.GCM_REGISTRATION_ID, registrationId);
        this.setRegistrationIdReported(false);
    }

    public String getDeviceApplicationInstanceId() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.INFOBIP_REGISTRATION_ID);
    }

    public String[] getUnreportedMessageIds() {
        return PreferenceHelper.findStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_MESSAGE_IDS);
    }

    private void addUnreportedMessageIds(String ... messageIDs) {
        PreferenceHelper.appendToStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_MESSAGE_IDS, messageIDs);
    }

    public void addSyncMessagesIds(String ... messageIDs) {
        String[] timestampMessageIdPair = this.concatTimestampToMessageId(messageIDs);
        PreferenceHelper.appendToStringArray(this.context, MobileMessagingProperty.INFOBIP_SYNC_MESSAGES_IDS, timestampMessageIdPair);
    }

    public String[] getSyncMessagesIds() {
        String[] messageIds = PreferenceHelper.findStringArray(this.context, MobileMessagingProperty.INFOBIP_SYNC_MESSAGES_IDS);
        ArrayList<String> messageIdsArrayList = new ArrayList<String>(Arrays.asList(messageIds));
        HashSet<String> messageIdsToSync = new HashSet<String>(messageIdsArrayList.size() <= 100 ? messageIdsArrayList.size() : 100);
        boolean shouldUpdateMessageIds = false;
        for (int i = 0; i < messageIdsArrayList.size(); ++i) {
            String syncMessage = messageIdsArrayList.get(i);
            String[] messageIdWithTimestamp = syncMessage.split(", ");
            String strTimeMessageReceived = messageIdWithTimestamp[1];
            long timeMessageReceived = Long.valueOf(strTimeMessageReceived);
            long timeInterval = Time.now() - timeMessageReceived;
            if (timeInterval > MESSAGE_EXPIRY_TIME || i >= 100) {
                messageIdsArrayList.remove(i);
                shouldUpdateMessageIds = true;
                continue;
            }
            messageIdsToSync.add(messageIdWithTimestamp[0]);
        }
        if (shouldUpdateMessageIds) {
            String[] messageIdsToUpdate = new String[messageIdsArrayList.size()];
            messageIdsToUpdate = messageIdsArrayList.toArray(messageIdsToUpdate);
            PreferenceHelper.remove(this.context, MobileMessagingProperty.INFOBIP_SYNC_MESSAGES_IDS);
            PreferenceHelper.appendToStringArray(this.context, MobileMessagingProperty.INFOBIP_SYNC_MESSAGES_IDS, messageIdsToUpdate);
        }
        return messageIdsToSync.toArray(new String[messageIdsToSync.size()]);
    }

    public void removeUnreportedMessageIds(String ... messageIDs) {
        PreferenceHelper.deleteFromStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_MESSAGE_IDS, messageIDs);
    }

    public String[] getUnreportedSeenMessageIds() {
        String[] ids = PreferenceHelper.findStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS);
        return this.filterOutGeneratedMessageIds(ids);
    }

    public void updateUnreportedSeenMessageIds(final Map<String, String> messageIdMap) {
        if (messageIdMap == null || messageIdMap.isEmpty()) {
            return;
        }
        PreferenceHelper.runTransaction(new PreferenceHelper.Transaction<Void>(){

            @Override
            public Void run() {
                String[] reports = PreferenceHelper.findStringArray(MobileMessagingCore.this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS);
                if (reports.length == 0) {
                    return null;
                }
                for (int i = 0; i < reports.length; ++i) {
                    String[] messageIdAndTimestamp = reports[i].split(", ");
                    String newMessageId = (String)messageIdMap.get(messageIdAndTimestamp[0]);
                    if (newMessageId == null) continue;
                    reports[i] = StringUtils.concat(newMessageId, messageIdAndTimestamp[1], ", ");
                }
                PreferenceHelper.saveStringArray(MobileMessagingCore.this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS, reports);
                return null;
            }
        });
    }

    public void updatedGeneratedMessageIDs(final Map<String, String> messageIdMap) {
        if (messageIdMap == null || messageIdMap.isEmpty()) {
            return;
        }
        PreferenceHelper.runTransaction(new PreferenceHelper.Transaction<Void>(){

            @Override
            public Void run() {
                String[] generatedMessageIds;
                for (String messageId : generatedMessageIds = MobileMessagingCore.this.getGeneratedMessageIds()) {
                    if (messageIdMap.get(messageId) == null) continue;
                    MobileMessagingCore.this.removeGeneratedMessageIds(new String[]{messageId});
                }
                return null;
            }
        });
    }

    public void addGeneratedMessageIds(String ... messageIDs) {
        PreferenceHelper.appendToStringArray(this.context, MobileMessagingProperty.INFOBIP_GENERATED_MESSAGE_IDS, messageIDs);
    }

    private String[] getGeneratedMessageIds() {
        return PreferenceHelper.findStringArray(this.context, MobileMessagingProperty.INFOBIP_GENERATED_MESSAGE_IDS);
    }

    private void removeGeneratedMessageIds(String ... messageIDs) {
        PreferenceHelper.deleteFromStringArray(this.context, MobileMessagingProperty.INFOBIP_GENERATED_MESSAGE_IDS, messageIDs);
    }

    private void addUnreportedSeenMessageIds(String ... messageIDs) {
        String[] seenMessages = this.concatTimestampToMessageId(messageIDs);
        PreferenceHelper.appendToStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS, seenMessages);
    }

    private String[] concatTimestampToMessageId(String[] messageIDs) {
        ArrayList<String> syncMessages = new ArrayList<String>(messageIDs.length);
        if (messageIDs.length > 0) {
            for (String messageId : messageIDs) {
                if (messageId == null) continue;
                String seenTimestamp = String.valueOf(Time.now());
                syncMessages.add(StringUtils.concat(messageId, seenTimestamp, ", "));
            }
        }
        return syncMessages.toArray(new String[syncMessages.size()]);
    }

    private String[] filterOutGeneratedMessageIds(String[] messageIDs) {
        String[] generatedMessageIDs = this.getGeneratedMessageIds();
        if (generatedMessageIDs.length == 0) {
            return messageIDs;
        }
        List<String> seenIds = this.getSeenMessageIdsFromReports(messageIDs);
        ArrayList<String> filteredSeenReports = new ArrayList<String>(Arrays.asList(messageIDs));
        for (String generatedMessageId : generatedMessageIDs) {
            int idIndex = seenIds.indexOf(generatedMessageId);
            if (idIndex < 0) continue;
            filteredSeenReports.remove(idIndex);
            seenIds.remove(idIndex);
        }
        return filteredSeenReports.toArray(new String[filteredSeenReports.size()]);
    }

    private List<String> getSeenMessageIdsFromReports(String[] reports) {
        ArrayList<String> ids = new ArrayList<String>();
        for (String report : reports) {
            ids.add(this.getSeenMessageIdFromReport(report));
        }
        return ids;
    }

    private String getSeenMessageIdFromReport(String report) {
        String[] reportContents = report.split(", ");
        return reportContents.length > 0 ? reportContents[0] : null;
    }

    public void removeUnreportedSeenMessageIds(String ... messageIDs) {
        PreferenceHelper.deleteFromStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS, messageIDs);
    }

    @Override
    public void setMessagesDelivered(String ... messageIds) {
        this.addUnreportedMessageIds(messageIds);
        this.addSyncMessagesIds(messageIds);
        this.sync();
    }

    @Override
    public void setMessagesSeen(String ... messageIds) {
        this.addUnreportedSeenMessageIds(messageIds);
        this.updateStoredMessagesWithSeenStatus(messageIds);
        this.sync();
    }

    private void updateStoredMessagesWithSeenStatus(String[] messageIds) {
        if (!this.isMessageStoreEnabled()) {
            return;
        }
        MessageStore messageStore = this.getMessageStore();
        List<String> messageIdList = Arrays.asList(messageIds);
        for (Message m : new ArrayList<Message>(messageStore.findAll(this.context))) {
            if (!messageIdList.contains(m.getMessageId())) continue;
            m.setSeenTimestamp(Time.now());
            messageStore.save(this.context, m);
        }
    }

    public NotificationSettings getNotificationSettings() {
        if (!this.isDisplayNotificationEnabled()) {
            return null;
        }
        if (null != this.notificationSettings) {
            return this.notificationSettings;
        }
        this.notificationSettings = new NotificationSettings(this.context);
        return this.notificationSettings;
    }

    private void setNotificationSettings(NotificationSettings notificationSettings) {
        PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.DISPLAY_NOTIFICATION_ENABLED, null != notificationSettings);
        this.notificationSettings = notificationSettings;
    }

    private boolean isDisplayNotificationEnabled() {
        return PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.DISPLAY_NOTIFICATION_ENABLED);
    }

    static void setGcmSenderId(Context context, String gcmSenderId) {
        if (StringUtils.isBlank(gcmSenderId)) {
            throw new IllegalArgumentException("gcmSenderId is mandatory! Get one here: https://developers.google.com/mobile/add?platform=android&cntapi=gcm");
        }
        PreferenceHelper.saveString(context, MobileMessagingProperty.GCM_SENDER_ID, gcmSenderId);
    }

    public String getGcmSenderId() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.GCM_SENDER_ID);
    }

    public boolean isRegistrationIdReported() {
        return this.registrationSynchronizer.isRegistrationIdReported(this.context);
    }

    private void setRegistrationIdReported(boolean registrationIdReported) {
        this.registrationSynchronizer.setRegistrationIdReported(this.context, registrationIdReported);
    }

    public static void setMessageStoreClass(Context context, Class<? extends MessageStore> messageStoreClass) {
        String value = null != messageStoreClass ? messageStoreClass.getName() : null;
        PreferenceHelper.saveString(context, MobileMessagingProperty.MESSAGE_STORE_CLASS, value);
    }

    @Override
    public MessageStore getMessageStore() {
        if (!this.isMessageStoreEnabled()) {
            return null;
        }
        if (null != this.messageStore) {
            return this.messageStore;
        }
        Class<? extends MessageStore> messageStoreClass = null;
        try {
            messageStoreClass = this.getMessageStoreClass();
            this.messageStore = messageStoreClass.newInstance();
            return this.messageStore;
        }
        catch (Exception e) {
            throw new MessageStoreInstantiationException("Can't create message store of type: " + messageStoreClass, e);
        }
    }

    protected Class<? extends MessageStore> getMessageStoreClass() {
        return PreferenceHelper.findClass(this.context, MobileMessagingProperty.MESSAGE_STORE_CLASS);
    }

    public boolean isMessageStoreEnabled() {
        return null != this.getMessageStoreClass();
    }

    public MobileMessagingStats getStats() {
        return this.stats;
    }

    public void setLastHttpException(Throwable lastHttpException) {
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.LAST_HTTP_EXCEPTION, ExceptionUtils.stacktrace(lastHttpException));
    }

    public String getLastHttpException() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.LAST_HTTP_EXCEPTION);
    }

    private void setApplicationCode(String applicationCode) {
        if (MobileMessagingCore.shouldSaveApplicationCode(this.context)) {
            if (StringUtils.isBlank(applicationCode)) {
                throw new IllegalArgumentException("applicationCode is mandatory! Get one here: https://portal.infobip.com/push/applications");
            }
            PreferenceHelper.saveString(this.context, MobileMessagingProperty.APPLICATION_CODE, applicationCode);
            return;
        }
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.APPLICATION_CODE, "");
    }

    public static String getApplicationCode(Context context) {
        if (MobileMessagingCore.shouldSaveApplicationCode(context)) {
            applicationCode = PreferenceHelper.findString(context, MobileMessagingProperty.APPLICATION_CODE);
            return applicationCode;
        }
        if (applicationCode != null) {
            return applicationCode;
        }
        if (applicationCodeProvider != null) {
            applicationCode = applicationCodeProvider.resolve();
            return applicationCode;
        }
        String appCodeProviderCanonicalClassName = MobileMessagingCore.getInstance(context).getApplicationCodeProviderClassName();
        try {
            Class<?> c = Class.forName(appCodeProviderCanonicalClassName);
            Object applicationCodeProvider = c.newInstance();
            Method resolve = ApplicationCodeProvider.class.getMethod("resolve", new Class[0]);
            applicationCode = String.valueOf(resolve.invoke(applicationCodeProvider, new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return applicationCode;
    }

    static void setApiUri(Context context, String apiUri) {
        if (StringUtils.isBlank(apiUri)) {
            throw new IllegalArgumentException("apiUri is mandatory! If in doubt, use " + MobileMessagingProperty.API_URI.getDefaultValue());
        }
        PreferenceHelper.saveString(context, MobileMessagingProperty.API_URI, apiUri);
    }

    public String getApiUri() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.API_URI);
    }

    static void setReportCarrierInfo(Context context, boolean reportCarrierInfo) {
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.REPORT_CARRIER_INFO, reportCarrierInfo);
    }

    static void setReportSystemInfo(Context context, boolean reportSystemInfo) {
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.REPORT_SYSTEM_INFO, reportSystemInfo);
    }

    static void setDoMarkSeenOnNotificationTap(Context context, boolean doMarkSeenOnNotificationTap) {
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.MARK_SEEN_ON_NOTIFICATION_TAP, doMarkSeenOnNotificationTap);
    }

    public static void setShouldSaveUserData(Context context, boolean shouldSaveUserData) {
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.SAVE_USER_DATA_ON_DISK, shouldSaveUserData);
    }

    public boolean shouldSaveUserData() {
        return PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.SAVE_USER_DATA_ON_DISK.getKey(), true);
    }

    public static void setShouldSaveAppCode(Context context, boolean shouldSaveAppCode) {
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.SAVE_APP_CODE_ON_DISK, shouldSaveAppCode);
    }

    public static boolean shouldSaveApplicationCode(Context context) {
        return PreferenceHelper.findBoolean(context, MobileMessagingProperty.SAVE_APP_CODE_ON_DISK.getKey(), true);
    }

    @Override
    public void cleanup() {
        MobileMessagingCore.cleanup(this.context);
    }

    private static void cleanup(Context context) {
        applicationCode = null;
        String gcmSenderID = PreferenceHelper.findString(context, MobileMessagingProperty.GCM_SENDER_ID);
        String gcmToken = PreferenceHelper.findString(context, MobileMessagingProperty.GCM_REGISTRATION_ID);
        Intent intent = new Intent("org.infobip.mobile.messaging.gcm.token.cleanup", null, context, MobileMessagingGcmIntentService.class);
        intent.putExtra("org.infobip.mobile.messaging.gcm.GCM_SENDER_ID", gcmSenderID);
        intent.putExtra("org.infobip.mobile.messaging.gcm.GCM_TOKEN", gcmToken);
        context.startService(intent);
        PreferenceHelper.remove(context, MobileMessagingProperty.GCM_REGISTRATION_ID);
        PreferenceHelper.remove(context, MobileMessagingProperty.INFOBIP_REGISTRATION_ID);
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.GCM_REGISTRATION_ID_REPORTED, false);
        PreferenceHelper.remove(context, MobileMessagingProperty.UNREPORTED_USER_DATA);
        PreferenceHelper.remove(context, MobileMessagingProperty.USER_DATA);
        PreferenceHelper.remove(context, MobileMessagingProperty.INFOBIP_UNREPORTED_MESSAGE_IDS);
        PreferenceHelper.remove(context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS);
        PreferenceHelper.remove(context, MobileMessagingProperty.UNREPORTED_SYSTEM_DATA);
        PreferenceHelper.remove(context, MobileMessagingProperty.REPORTED_SYSTEM_DATA_HASH);
    }

    @Override
    public void syncUserData(UserData userData) {
        this.syncUserData(userData, null);
    }

    @Override
    public void syncUserData(UserData userData, MobileMessaging.ResultListener<UserData> listener) {
        UserData userDataToReport = new UserData();
        if (userData != null) {
            String existingUserId;
            UserData existingData = this.getUnreportedUserData();
            String userId = userData.getExternalUserId();
            String string = existingUserId = existingData != null ? existingData.getExternalUserId() : null;
            if (!StringUtils.isEqual(userId, existingUserId)) {
                PreferenceHelper.remove(this.context, MobileMessagingProperty.USER_DATA);
                existingData = null;
            }
            userDataToReport = UserData.merge(existingData, userData);
        } else {
            String externalUserId;
            UserData existingUserData = this.getUserData();
            String string = externalUserId = existingUserData != null ? existingUserData.getExternalUserId() : null;
            if (externalUserId != null) {
                userDataToReport.setExternalUserId(externalUserId);
            }
        }
        this.userDataSynchronizer.synchronize((MobileMessaging.ResultListener)listener, userDataToReport);
    }

    @Override
    public void fetchUserData() {
        this.fetchUserData(null);
    }

    @Override
    public void fetchUserData(MobileMessaging.ResultListener<UserData> listener) {
        this.syncUserData(null, listener);
    }

    @Override
    @Nullable
    public UserData getUserData() {
        UserData existing = null;
        if (PreferenceHelper.contains(this.context, MobileMessagingProperty.USER_DATA)) {
            existing = new UserData(PreferenceHelper.findString(this.context, MobileMessagingProperty.USER_DATA));
        }
        return UserData.merge(existing, this.getUnreportedUserData());
    }

    @Nullable
    public UserData getUnreportedUserData() {
        if (PreferenceHelper.contains(this.context, MobileMessagingProperty.UNREPORTED_USER_DATA)) {
            return new UserData(PreferenceHelper.findString(this.context, MobileMessagingProperty.UNREPORTED_USER_DATA));
        }
        return null;
    }

    public void setUserDataReportedWithError() {
        this.setUserDataReported(null);
    }

    public void setUserDataReported(UserData userData) {
        if (userData != null && this.shouldSaveUserData()) {
            PreferenceHelper.saveString(this.context, MobileMessagingProperty.USER_DATA, userData.toString());
        }
        PreferenceHelper.remove(this.context, MobileMessagingProperty.UNREPORTED_USER_DATA);
    }

    @Override
    public void sendMessages(Message ... messages) {
        this.sendMessages((MobileMessaging.ResultListener<Message[]>)null, messages);
    }

    @Override
    public void sendMessages(MobileMessaging.ResultListener<Message[]> listener, Message ... messages) {
        if (this.isMessageStoreEnabled()) {
            this.getMessageStore().save(this.context, messages);
        }
        this.messageSender.send(this.context, this.getStats(), this.registrationAlignedExecutor, listener, messages);
    }

    public void reportSystemData() {
        boolean reportEnabled = PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.REPORT_SYSTEM_INFO);
        SystemData data = new SystemData(SoftwareInformation.getLibraryVersion(), reportEnabled ? SystemInformation.getAndroidSystemVersion() : "", reportEnabled ? DeviceInformation.getDeviceManufacturer() : "", reportEnabled ? DeviceInformation.getDeviceModel() : "", reportEnabled ? SoftwareInformation.getAppVersion(this.context) : "", this.isGeofencingActivated(), SoftwareInformation.areNotificationsEnabled(this.context));
        Integer hash = PreferenceHelper.findInt(this.context, MobileMessagingProperty.REPORTED_SYSTEM_DATA_HASH);
        if (hash.intValue() != data.hashCode()) {
            PreferenceHelper.saveString(this.context, MobileMessagingProperty.UNREPORTED_SYSTEM_DATA, data.toString());
        }
        this.systemDataReporter.synchronize();
    }

    boolean isGeofencingActivated() {
        return PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.GEOFENCING_ACTIVATED.getKey(), false);
    }

    public SystemData getUnreportedSystemData() {
        if (PreferenceHelper.contains(this.context, MobileMessagingProperty.UNREPORTED_SYSTEM_DATA)) {
            return SystemData.fromJson(PreferenceHelper.findString(this.context, MobileMessagingProperty.UNREPORTED_SYSTEM_DATA));
        }
        return null;
    }

    public void setSystemDataReported() {
        SystemData systemData = this.getUnreportedSystemData();
        if (systemData == null) {
            return;
        }
        PreferenceHelper.remove(this.context, MobileMessagingProperty.UNREPORTED_SYSTEM_DATA);
        PreferenceHelper.saveInt(this.context, MobileMessagingProperty.REPORTED_SYSTEM_DATA_HASH, systemData.hashCode());
    }

    private void setApplicationCodeProviderClassName(ApplicationCodeProvider applicationCodeProvider) {
        MobileMessagingCore.applicationCodeProvider = applicationCodeProvider;
        if (applicationCodeProvider == null) {
            return;
        }
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.APP_CODE_PROVIDER_CANONICAL_CLASS_NAME, applicationCodeProvider.getClass().getCanonicalName());
    }

    private String getApplicationCodeProviderClassName() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.APP_CODE_PROVIDER_CANONICAL_CLASS_NAME);
    }

    public static boolean hasGeo(Message message) {
        if (message == null || message.getInternalData() == null) {
            return false;
        }
        try {
            JSONObject geo = new JSONObject(message.getInternalData());
            return geo.getJSONArray("geo") != null && geo.getJSONArray("geo").length() > 0;
        }
        catch (JSONException e) {
            MobileMessagingLogger.e(e.getMessage());
            return false;
        }
    }

    public static final class Builder {
        private final Application application;
        private NotificationSettings notificationSettings = null;
        private String applicationCode = null;
        private ApplicationCodeProvider applicationCodeProvider;

        public Builder(Application application) {
            if (null == application) {
                throw new IllegalArgumentException("application is mandatory!");
            }
            this.application = application;
        }

        private void validateWithParam(Object o) {
            if (null != o) {
                return;
            }
            throw new IllegalArgumentException("Can't use 'with' method with null argument!");
        }

        public Builder withDisplayNotification(NotificationSettings notificationSettings) {
            this.notificationSettings = notificationSettings;
            return this;
        }

        public Builder withApplicationCode(String applicationCode) {
            this.validateWithParam(applicationCode);
            this.applicationCode = applicationCode;
            return this;
        }

        public Builder withApplicationCode(ApplicationCodeProvider applicationCodeProvider) {
            this.validateWithParam(applicationCodeProvider);
            this.applicationCodeProvider = applicationCodeProvider;
            return this;
        }

        public MobileMessagingCore build() {
            MobileMessagingCore mobileMessagingCore;
            if (MobileMessagingCore.shouldSaveApplicationCode(this.application.getApplicationContext()) && !this.applicationCode.equals(MobileMessagingCore.getApplicationCode(this.application.getApplicationContext()))) {
                MobileMessagingCore.cleanup((Context)this.application);
            }
            instance = mobileMessagingCore = new MobileMessagingCore((Context)this.application);
            mobileMessagingCore.setNotificationSettings(this.notificationSettings);
            mobileMessagingCore.setApplicationCode(this.applicationCode);
            mobileMessagingCore.setApplicationCodeProviderClassName(this.applicationCodeProvider);
            mobileMessagingCore.activityLifecycleMonitor = new ActivityLifecycleMonitor(this.application.getApplicationContext());
            mobileMessagingCore.mobileNetworkStateListener = new MobileNetworkStateListener((Context)this.application);
            mobileMessagingCore.playServicesSupport = new PlayServicesSupport();
            mobileMessagingCore.playServicesSupport.checkPlayServices(this.application.getApplicationContext());
            return mobileMessagingCore;
        }
    }
}

