/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.os.Bundle;
import android.support.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import org.infobip.mobile.messaging.CustomUserDataValue;
import org.infobip.mobile.messaging.api.shaded.google.gson.Gson;
import org.infobip.mobile.messaging.api.shaded.google.gson.GsonBuilder;

public class UserData {
    private String externalUserId;
    private Map<String, Object> predefinedUserData;
    private Map<String, CustomUserDataValue> customUserData;

    public UserData() {
        this.externalUserId = null;
        this.predefinedUserData = new HashMap<String, Object>();
        this.customUserData = new HashMap<String, CustomUserDataValue>();
    }

    public UserData(String userData) {
        Gson gson = new Gson();
        UserData data = (UserData)gson.fromJson(userData, UserData.class);
        this.externalUserId = data.externalUserId;
        this.predefinedUserData = data.predefinedUserData;
        this.customUserData = data.customUserData;
    }

    protected UserData(String externalUserId, Map<String, Object> predefinedUserData, Map<String, CustomUserDataValue> customUserData) {
        this.externalUserId = externalUserId;
        this.predefinedUserData = predefinedUserData;
        this.customUserData = customUserData;
    }

    @Nullable
    public static UserData merge(UserData old, UserData latest) {
        if (old == null && latest == null) {
            return null;
        }
        UserData merged = new UserData();
        merged.add(old);
        merged.add(latest);
        return merged;
    }

    public static UserData createFrom(Bundle bundle) {
        return new UserData(bundle.getString("org.infobip.mobile.messaging.userdata"));
    }

    private void add(UserData data) {
        if (data == null) {
            return;
        }
        if (data.predefinedUserData != null) {
            this.predefinedUserData.putAll(data.predefinedUserData);
        }
        if (data.customUserData != null) {
            this.customUserData.putAll(data.customUserData);
        }
        this.externalUserId = data.externalUserId;
    }

    public String toString() {
        Gson gson = new GsonBuilder().serializeNulls().create();
        return gson.toJson((Object)this);
    }

    public Map<String, Object> getPredefinedUserData() {
        return this.predefinedUserData;
    }

    public void setPredefinedUserData(Map<String, Object> predefinedUserData) {
        this.predefinedUserData = predefinedUserData;
    }

    public void setCustomUserData(Map<String, CustomUserDataValue> customUserData) {
        this.customUserData = customUserData;
    }

    public Map<String, CustomUserDataValue> getCustomUserData() {
        return this.customUserData;
    }

    public void setCustomUserDataElement(String key, CustomUserDataValue customUserDataValue) {
        this.customUserData.put(key, customUserDataValue);
    }

    public CustomUserDataValue getCustomUserDataValue(String key) {
        return this.customUserData.get(key);
    }

    public void removeCustomUserDataElement(String key) {
        this.customUserData.put(key, null);
    }

    public String getMsisdn() {
        return (String)this.getField(PredefinedField.MSISDN);
    }

    public void setMsisdn(String msisdn) {
        this.setField(PredefinedField.MSISDN, msisdn);
    }

    public String getFirstName() {
        return (String)this.getField(PredefinedField.FIRST_NAME);
    }

    public void setFirstName(String firstName) {
        this.setField(PredefinedField.FIRST_NAME, firstName);
    }

    public String getLastName() {
        return (String)this.getField(PredefinedField.LAST_NAME);
    }

    public void setLastName(String lastName) {
        this.setField(PredefinedField.LAST_NAME, lastName);
    }

    public String getGender() {
        return (String)this.getField(PredefinedField.GENDER);
    }

    public void setGender(String gender) {
        this.setField(PredefinedField.GENDER, gender);
    }

    public String getBirthdate() {
        return (String)this.getField(PredefinedField.BIRTHDATE);
    }

    public void setBirthdate(String birthdate) {
        this.setField(PredefinedField.BIRTHDATE, birthdate);
    }

    public String getEmail() {
        return (String)this.getField(PredefinedField.EMAIL);
    }

    public void setEmail(String email) {
        this.setField(PredefinedField.EMAIL, email);
    }

    public String getMiddleName() {
        return (String)this.getField(PredefinedField.MIDDLE_NAME);
    }

    public void setMiddleName(String middleName) {
        this.setField(PredefinedField.MIDDLE_NAME, middleName);
    }

    public String getLandlineNumber() {
        return (String)this.getField(PredefinedField.LANDLINE_NUMBER);
    }

    public void setLandlineNumber(String telephone) {
        this.setField(PredefinedField.LANDLINE_NUMBER, telephone);
    }

    public void setExternalUserId(String externalUserId) {
        this.externalUserId = externalUserId;
    }

    public String getExternalUserId() {
        return this.externalUserId;
    }

    private <T> T getField(PredefinedField field) {
        if (this.predefinedUserData == null) {
            return null;
        }
        Object object = this.predefinedUserData.get(field.getKey());
        try {
            return (T)object;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private void setField(PredefinedField field, Object value) {
        this.predefinedUserData.put(field.getKey(), value);
    }

    protected static enum PredefinedField {
        MSISDN("msisdn"),
        FIRST_NAME("firstName"),
        LAST_NAME("lastName"),
        MIDDLE_NAME("middleName"),
        GENDER("gender"),
        BIRTHDATE("birthdate"),
        EMAIL("email"),
        LANDLINE_NUMBER("telephone");

        private final String key;

        private PredefinedField(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

