/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.gcm;

import android.content.Context;
import com.google.android.gms.gcm.GcmPubSub;
import com.google.android.gms.iid.InstanceID;
import java.io.IOException;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobile.InternalSdkError;
import org.infobip.mobile.messaging.platform.AndroidBroadcaster;
import org.infobip.mobile.messaging.util.StringUtils;

class RegistrationTokenHandler {
    private static final String[] TOPICS = new String[]{"global"};

    RegistrationTokenHandler() {
    }

    void handleRegistrationTokenUpdate(Context context) {
        try {
            InstanceID instanceID = InstanceID.getInstance((Context)context);
            String token = instanceID.getToken(MobileMessagingCore.getInstance(context).getGcmSenderId(), "GCM", null);
            new AndroidBroadcaster(context).registrationAcquired(token);
            this.sendRegistrationToServer(context, token);
            this.subscribeTopics(context, token);
        }
        catch (IOException e) {
            MobileMessagingLogger.e(InternalSdkError.ERROR_TOKEN_REFRESH.get(), e);
        }
    }

    private void sendRegistrationToServer(Context context, String token) {
        boolean saveNeeded;
        if (StringUtils.isBlank(token)) {
            return;
        }
        MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance(context);
        String infobipRegistrationId = mobileMessagingCore.getDeviceApplicationInstanceId();
        boolean bl = saveNeeded = null == infobipRegistrationId || null == mobileMessagingCore.getRegistrationId() || !token.equals(mobileMessagingCore.getRegistrationId()) || !mobileMessagingCore.isRegistrationIdReported();
        if (saveNeeded) {
            mobileMessagingCore.setRegistrationId(token);
        }
        mobileMessagingCore.sync();
    }

    private void subscribeTopics(Context context, String token) throws IOException {
        GcmPubSub pubSub = GcmPubSub.getInstance((Context)context);
        for (String topic : TOPICS) {
            pubSub.subscribe(token, "/topics/" + topic, null);
        }
    }

    void handleRegistrationTokenCleanup(Context context, String gcmSenderID, String gcmToken) {
        try {
            InstanceID instanceID = InstanceID.getInstance((Context)context);
            instanceID.deleteToken(gcmSenderID, gcmToken);
        }
        catch (IOException e) {
            MobileMessagingLogger.e(InternalSdkError.ERROR_GCM_TOKEN_CLEANUP.get(), e);
        }
    }
}

