/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.messages;

import android.content.Context;
import android.os.AsyncTask;
import java.util.ArrayList;
import java.util.Map;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingLogger;
import org.infobip.mobile.messaging.api.messages.MoMessage;
import org.infobip.mobile.messaging.api.messages.MoMessagesBody;
import org.infobip.mobile.messaging.api.messages.MoMessagesResponse;
import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;
import org.infobip.mobile.messaging.mobile.InternalSdkError;
import org.infobip.mobile.messaging.mobile.MobileApiResourceProvider;
import org.infobip.mobile.messaging.mobile.messages.SendMessageResult;
import org.infobip.mobile.messaging.util.StringUtils;

class SendMessageTask
extends AsyncTask<Message, Void, SendMessageResult> {
    private final Context context;

    SendMessageTask(Context context) {
        this.context = context;
    }

    protected SendMessageResult doInBackground(Message ... messages) {
        MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance(this.context);
        String deviceApplicationInstanceId = mobileMessagingCore.getDeviceApplicationInstanceId();
        if (StringUtils.isBlank(deviceApplicationInstanceId)) {
            MobileMessagingLogger.e(InternalSdkError.NO_VALID_REGISTRATION.get());
            return new SendMessageResult(InternalSdkError.NO_VALID_REGISTRATION.getException());
        }
        try {
            MoMessagesBody moMessagesBody = new MoMessagesBody();
            moMessagesBody.setFrom(deviceApplicationInstanceId);
            ArrayList<MoMessage> moMessages = new ArrayList<MoMessage>();
            for (Message message : messages) {
                String customPayloadString = message.getCustomPayload() != null ? message.getCustomPayload().toString() : null;
                Map customPayloadMap = (Map)new JsonSerializer().deserialize(customPayloadString, Map.class);
                moMessages.add(new MoMessage(message.getMessageId(), message.getDestination(), message.getBody(), customPayloadMap));
            }
            moMessagesBody.setMessages(moMessages.toArray(new MoMessage[moMessages.size()]));
            MoMessagesResponse moMessagesResponse = MobileApiResourceProvider.INSTANCE.getMobileApiMessages(this.context).sendMO(moMessagesBody);
            return new SendMessageResult(moMessagesResponse.getMessages());
        }
        catch (Exception e) {
            mobileMessagingCore.setLastHttpException(e);
            MobileMessagingLogger.e("Error sending MO messages!", e);
            return new SendMessageResult(e);
        }
    }
}

