/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.messages;

import android.content.Context;
import android.os.AsyncTask;
import java.util.ArrayList;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingLogger;
import org.infobip.mobile.messaging.api.messages.SyncMessagesBody;
import org.infobip.mobile.messaging.api.messages.SyncMessagesResponse;
import org.infobip.mobile.messaging.mobile.MobileApiResourceProvider;
import org.infobip.mobile.messaging.mobile.messages.SyncMessagesResult;
import org.infobip.mobile.messaging.util.StringUtils;

class SyncMessagesTask
extends AsyncTask<Object, Void, SyncMessagesResult> {
    private final Context context;

    SyncMessagesTask(Context context) {
        this.context = context;
    }

    protected SyncMessagesResult doInBackground(Object ... notUsed) {
        MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance(this.context);
        if (StringUtils.isBlank(mobileMessagingCore.getDeviceApplicationInstanceId())) {
            MobileMessagingLogger.w("Registration is not available yet");
            return new SyncMessagesResult(new SyncMessagesResponse(new ArrayList()));
        }
        try {
            String[] messageIds = mobileMessagingCore.getSyncMessagesIds();
            String[] unreportedMessageIds = mobileMessagingCore.getUnreportedMessageIds();
            SyncMessagesBody syncMessagesBody = new SyncMessagesBody(messageIds, unreportedMessageIds);
            SyncMessagesResponse syncMessagesResponse = MobileApiResourceProvider.INSTANCE.getMobileApiMessages(this.context).sync(syncMessagesBody);
            mobileMessagingCore.removeUnreportedMessageIds(unreportedMessageIds);
            return new SyncMessagesResult(syncMessagesResponse);
        }
        catch (Exception e) {
            mobileMessagingCore.setLastHttpException(e);
            MobileMessagingLogger.e("Error syncing messages!", e);
            this.cancel(true);
            return new SyncMessagesResult(e);
        }
    }
}

