/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.registration;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.AsyncTask;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingLogger;
import org.infobip.mobile.messaging.api.registration.RegistrationResponse;
import org.infobip.mobile.messaging.mobile.MobileApiResourceProvider;
import org.infobip.mobile.messaging.mobile.registration.UpsertRegistrationResult;

@TargetApi(value=14)
public class UpsertRegistrationTask
extends AsyncTask<Boolean, Void, UpsertRegistrationResult> {
    private final Context context;

    UpsertRegistrationTask(Context context) {
        this.context = context;
    }

    protected UpsertRegistrationResult doInBackground(Boolean ... params) {
        MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance(this.context);
        try {
            String registrationId = mobileMessagingCore.getRegistrationId();
            Boolean pushRegistrationEnabled = params.length > 0 ? params[0] : null;
            RegistrationResponse registrationResponse = MobileApiResourceProvider.INSTANCE.getMobileApiRegistration(this.context).upsert(registrationId, pushRegistrationEnabled);
            return new UpsertRegistrationResult(registrationResponse.getDeviceApplicationInstanceId(), registrationResponse.getPushRegistrationEnabled());
        }
        catch (Exception e) {
            mobileMessagingCore.setLastHttpException(e);
            MobileMessagingLogger.e("Error creating registration!", e);
            this.cancel(true);
            return new UpsertRegistrationResult(e);
        }
    }
}

