/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.seen;

import android.content.Context;
import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobile.BatchReporter;
import org.infobip.mobile.messaging.mobile.MobileMessagingError;
import org.infobip.mobile.messaging.mobile.seen.SeenStatusReportResult;
import org.infobip.mobile.messaging.mobile.seen.SeenStatusReportTask;
import org.infobip.mobile.messaging.mobile.synchronizer.RetryableSynchronizer;
import org.infobip.mobile.messaging.mobile.synchronizer.Task;
import org.infobip.mobile.messaging.platform.Broadcaster;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.stats.MobileMessagingStatsError;

public class SeenStatusReporter
extends RetryableSynchronizer {
    private static BatchReporter batchReporter = null;
    private final Broadcaster broadcaster;

    public SeenStatusReporter(Context context, MobileMessagingStats stats, Executor executor, Broadcaster broadcaster) {
        super(context, stats, executor);
        this.broadcaster = broadcaster;
    }

    @Override
    public void synchronize() {
        String[] unreportedSeenMessageIds = MobileMessagingCore.getInstance(this.context).getUnreportedSeenMessageIds();
        if (unreportedSeenMessageIds.length == 0) {
            return;
        }
        if (batchReporter == null) {
            batchReporter = new BatchReporter(this.context);
        }
        batchReporter.put(new Runnable(){

            @Override
            public void run() {
                new SeenStatusReportTask(SeenStatusReporter.this.context){

                    protected void onPostExecute(SeenStatusReportResult result) {
                        if (result.hasError()) {
                            MobileMessagingLogger.e("MobileMessaging API returned error (seen messages)!");
                            SeenStatusReporter.this.stats.reportError(MobileMessagingStatsError.SEEN_REPORTING_ERROR);
                            SeenStatusReporter.this.broadcaster.error(MobileMessagingError.createFrom(result.getError()));
                            return;
                        }
                        SeenStatusReporter.this.broadcaster.seenStatusReported(result.getMessageIDs());
                    }

                    protected void onCancelled(SeenStatusReportResult result) {
                        MobileMessagingLogger.e("Error reporting seen status!");
                        SeenStatusReporter.this.stats.reportError(MobileMessagingStatsError.SEEN_REPORTING_ERROR);
                        SeenStatusReporter.this.broadcaster.error(MobileMessagingError.createFrom(result.getError()));
                    }
                }.executeOnExecutor(SeenStatusReporter.this.executor, new Object[0]);
            }
        });
    }

    @Override
    public Task getTask() {
        return Task.SEEN_STATUS_REPORT;
    }
}

