/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.storage;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcel;
import android.util.Base64;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.dal.bundle.FCMMessageMapper;
import org.infobip.mobile.messaging.storage.MessageStore;
import org.infobip.mobile.messaging.util.PreferenceHelper;

@Deprecated
public class SharedPreferencesMessageStore
implements MessageStore {
    private static final String INFOBIP_MESSAGE_DATA_SET = "org.infobip.mobile.messaging.store.DATA";

    @Override
    public void save(Context context, Message ... messages) {
        this.addMessages(context, messages);
    }

    @Override
    public List<Message> findAll(Context context) {
        return PreferenceHelper.find(context, this.getStoreTag(), new ArrayList(), new PreferenceHelper.SetConverter<List<Message>>(){

            @Override
            public List<Message> convert(Set<String> set) {
                ArrayList<Message> messages = new ArrayList<Message>();
                for (String bundle : set) {
                    messages.add(FCMMessageMapper.fromCloudBundle(SharedPreferencesMessageStore.this.deserialize(bundle)));
                }
                return messages;
            }
        });
    }

    @Override
    public void deleteAll(Context context) {
        PreferenceHelper.remove(context, this.getStoreTag());
    }

    @Override
    public long countAll(Context context) {
        return this.findAll(context).size();
    }

    private void addMessages(Context context, final Message ... messages) {
        PreferenceHelper.editSet(context, this.getStoreTag(), new PreferenceHelper.SetMutator(){

            @Override
            public void mutate(Set<String> set) {
                for (Message message : messages) {
                    for (String serializedBundle : new HashSet<String>(set)) {
                        Message messageInSet = FCMMessageMapper.fromCloudBundle(SharedPreferencesMessageStore.this.deserialize(serializedBundle));
                        if (!messageInSet.getMessageId().equals(message.getMessageId())) continue;
                        set.remove(serializedBundle);
                        break;
                    }
                    set.add(SharedPreferencesMessageStore.this.serialize(FCMMessageMapper.toCloudBundle(message)));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String serialize(Bundle in) {
        Parcel parcel = Parcel.obtain();
        try {
            in.writeToParcel(parcel, 0);
            String string = Base64.encodeToString((byte[])parcel.marshall(), (int)0);
            return string;
        }
        finally {
            parcel.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bundle deserialize(String serialized) {
        if (serialized == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            byte[] data = Base64.decode((String)serialized, (int)0);
            parcel.unmarshall(data, 0, data.length);
            parcel.setDataPosition(0);
            Bundle bundle = parcel.readBundle();
            return bundle;
        }
        finally {
            parcel.recycle();
        }
    }

    protected String getStoreTag() {
        return INFOBIP_MESSAGE_DATA_SET;
    }
}

