/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.dal.sqlite;

import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.support.annotation.NonNull;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infobip.mobile.messaging.dal.sqlite.DatabaseContract;
import org.infobip.mobile.messaging.dal.sqlite.DatabaseHelper;
import org.infobip.mobile.messaging.dal.sqlite.SharedPreferencesMigrator;
import org.infobip.mobile.messaging.dal.sqlite.SqliteDatabaseProvider;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;

public class DatabaseHelperImpl
extends SQLiteOpenHelper
implements DatabaseHelper,
SqliteDatabaseProvider {
    private static final Map<Class<? extends DatabaseContract.DatabaseObject>, DatabaseContract.DatabaseObject> databaseObjectsCache = new HashMap<Class<? extends DatabaseContract.DatabaseObject>, DatabaseContract.DatabaseObject>();
    static final int VER_2017_JAN_12 = 1;
    static final int VER_2017_FEB_14 = 2;
    static final int VER_2017_MAY_15 = 3;
    private static final int VER_CURRENT = 3;
    static final String DATABASE_NAME = "mm_infobip_database.db";
    private static final String SQL_CREATE_MESSAGES_TABLE = "CREATE TABLE messages (id TEXT PRIMARY KEY NOT NULL ON CONFLICT FAIL, title TEXT, body TEXT, sound TEXT, vibrate INTEGER NOT NULL DEFAULT 1, icon TEXT, silent INTEGER NOT NULL DEFAULT 0, category TEXT, _from TEXT, received_timestamp INTEGER, seen_timestamp INTEGER, internal_data TEXT, custom_payload TEXT, destination TEXT, status TEXT,status_message TEXT)";
    private static final String SQL_CREATE_GEO_MESSAGES_TABLE = "CREATE TABLE geo_messages (id TEXT PRIMARY KEY NOT NULL ON CONFLICT FAIL, title TEXT, body TEXT, sound TEXT, vibrate INTEGER NOT NULL DEFAULT 1, icon TEXT, silent INTEGER NOT NULL DEFAULT 0, category TEXT, _from TEXT, received_timestamp INTEGER, seen_timestamp INTEGER, internal_data TEXT, custom_payload TEXT, destination TEXT, status TEXT,status_message TEXT)";
    private static final String SQL_ALTER_TABLE_MESSAGES_WITH_CONTENT_URL = "ALTER TABLE messages ADD COLUMN content_url TEXT;";
    private static final String SQL_ALTER_TABLE_GEO_MESSAGES_WITH_CONTENT_URL = "ALTER TABLE geo_messages ADD COLUMN content_url TEXT;";
    private final Context context;
    private SQLiteDatabase sqLiteDatabase;

    public DatabaseHelperImpl(Context context) {
        super(context, DATABASE_NAME, null, 3);
        this.context = context;
    }

    private SQLiteDatabase db() {
        if (this.sqLiteDatabase == null) {
            this.sqLiteDatabase = this.getWritableDatabase();
        }
        return this.sqLiteDatabase;
    }

    @Override
    public <T extends DatabaseContract.DatabaseObject> List<T> findAll(Class<T> cls) {
        Cursor cursor = this.db().rawQuery("SELECT * FROM " + this.getTableName(cls), new String[0]);
        List<T> objects = this.loadFromCursor(cursor, cls);
        cursor.close();
        return objects;
    }

    @Override
    public <T extends DatabaseContract.DatabaseObject> T find(Class<T> cls, @NonNull String primaryKey) {
        Cursor cursor = this.db().rawQuery("SELECT * FROM " + this.getTableName(cls) + " WHERE " + this.getPrimaryKeyColumn(cls) + " = ?", new String[]{primaryKey});
        List<T> objects = this.loadFromCursor(cursor, cls);
        cursor.close();
        return (T)(objects != null && !objects.isEmpty() ? (DatabaseContract.DatabaseObject)objects.get(0) : null);
    }

    @Override
    public <T extends DatabaseContract.DatabaseObject> long countAll(Class<T> cls) {
        return DatabaseUtils.queryNumEntries((SQLiteDatabase)this.db(), (String)this.getTableName(cls));
    }

    @Override
    public void save(DatabaseContract.DatabaseObject object) {
        this.db().insertWithOnConflict(object.getTableName(), null, object.getContentValues(), 5);
    }

    @Override
    public <T extends DatabaseContract.DatabaseObject> void deleteAll(Class<T> cls) {
        this.db().delete(this.getTableName(cls), null, new String[0]);
    }

    @Override
    public <T extends DatabaseContract.DatabaseObject> void delete(Class<T> cls, @NonNull String primaryKey) {
        this.db().delete(this.getTableName(cls), this.getPrimaryKeyColumn(cls) + "=?", new String[]{primaryKey});
    }

    @Override
    public <T extends DatabaseContract.DatabaseObject> void delete(Class<T> cls, String[] primaryKeys) {
        this.db().delete(this.getTableName(cls), this.getPrimaryKeyColumn(cls) + " IN (" + new String(new char[primaryKeys.length - 1]).replace("\u0000", "?,") + "?)", primaryKeys);
    }

    public void onCreate(SQLiteDatabase db) {
        db.beginTransaction();
        db.execSQL(SQL_CREATE_MESSAGES_TABLE);
        db.execSQL(SQL_ALTER_TABLE_MESSAGES_WITH_CONTENT_URL);
        db.execSQL(SQL_CREATE_GEO_MESSAGES_TABLE);
        db.execSQL(SQL_ALTER_TABLE_GEO_MESSAGES_WITH_CONTENT_URL);
        db.setTransactionSuccessful();
        db.endTransaction();
        SharedPreferencesMigrator.migrateMessages(this.context, db);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        int version = oldVersion;
        if (version <= 1) {
            db.execSQL(SQL_CREATE_GEO_MESSAGES_TABLE);
            version = 2;
        }
        if (version <= 2) {
            db.execSQL(SQL_ALTER_TABLE_MESSAGES_WITH_CONTENT_URL);
            db.execSQL(SQL_ALTER_TABLE_GEO_MESSAGES_WITH_CONTENT_URL);
            version = 3;
        }
        if (version != 3) {
            MobileMessagingLogger.e("SQLite DB version is not what expected: 3");
        }
    }

    private DatabaseContract.DatabaseObject emptyDatabaseObject(Class<? extends DatabaseContract.DatabaseObject> cls) {
        DatabaseContract.DatabaseObject emptyInstance = databaseObjectsCache.get(cls);
        if (emptyInstance != null) {
            return emptyInstance;
        }
        try {
            emptyInstance = cls.newInstance();
        }
        catch (Exception e) {
            MobileMessagingLogger.e(Log.getStackTraceString((Throwable)e));
            throw new RuntimeException(e);
        }
        databaseObjectsCache.put(cls, emptyInstance);
        return emptyInstance;
    }

    private <T extends DatabaseContract.DatabaseObject> List<T> loadFromCursor(Cursor cursor, Class<T> cls) {
        if (cursor.getCount() == 0) {
            cursor.close();
            return new ArrayList();
        }
        ArrayList<DatabaseContract.DatabaseObject> objects = new ArrayList<DatabaseContract.DatabaseObject>();
        if (cursor.moveToFirst()) {
            do {
                try {
                    DatabaseContract.DatabaseObject object = (DatabaseContract.DatabaseObject)cls.newInstance();
                    object.fillFromCursor(cursor);
                    objects.add(object);
                }
                catch (Exception e) {
                    MobileMessagingLogger.e(Log.getStackTraceString((Throwable)e));
                }
            } while (cursor.moveToNext());
        }
        return objects;
    }

    private String getTableName(Class<? extends DatabaseContract.DatabaseObject> cls) {
        DatabaseContract.DatabaseObject o = this.emptyDatabaseObject(cls);
        return o != null ? o.getTableName() : null;
    }

    private String getPrimaryKeyColumn(Class<? extends DatabaseContract.DatabaseObject> cls) {
        DatabaseContract.DatabaseObject o = this.emptyDatabaseObject(cls);
        return o != null ? o.getPrimaryKeyColumnName() : null;
    }

    @Override
    public SQLiteDatabase getDatabase() {
        return this.db();
    }

    @Override
    public void deleteDatabase() {
        if (this.sqLiteDatabase != null) {
            this.sqLiteDatabase.close();
            this.sqLiteDatabase = null;
        }
        this.context.deleteDatabase(DATABASE_NAME);
    }
}

