/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.gcm;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.gcm.MobileMessageHandler;
import org.infobip.mobile.messaging.gcm.RegistrationTokenHandler;
import org.infobip.mobile.messaging.notification.NotificationHandler;
import org.infobip.mobile.messaging.platform.AndroidBroadcaster;

public class MobileMessagingGcmIntentService
extends IntentService {
    public static final String ACTION_GCM_MESSAGE_RECEIVE = "com.google.android.c2dm.intent.RECEIVE";
    public static final String ACTION_ACQUIRE_INSTANCE_ID = "org.infobip.mobile.messaging.gcm.INSTANCE_ID";
    public static final String ACTION_TOKEN_CLEANUP = "org.infobip.mobile.messaging.gcm.token.cleanup";
    public static final String EXTRA_GCM_SENDER_ID = "org.infobip.mobile.messaging.gcm.GCM_SENDER_ID";
    public static final String EXTRA_GCM_TOKEN = "org.infobip.mobile.messaging.gcm.GCM_TOKEN";
    private MobileMessageHandler mobileMessageHandler;
    private RegistrationTokenHandler registrationTokenHandler = new RegistrationTokenHandler();

    public MobileMessagingGcmIntentService() {
        super("MobileMessaging-" + MobileMessagingGcmIntentService.class.getSimpleName());
    }

    public void onHandleIntent(Intent intent) {
        if (intent == null) {
            return;
        }
        String action = intent.getAction();
        if (action == null) {
            return;
        }
        if (this.mobileMessageHandler == null) {
            NotificationHandler notificationHandler = MobileMessagingCore.resolveNotificationHandler((Context)this);
            this.mobileMessageHandler = new MobileMessageHandler(new AndroidBroadcaster((Context)this), notificationHandler);
        }
        switch (action) {
            case "com.google.android.c2dm.intent.RECEIVE": {
                this.mobileMessageHandler.handleMessage((Context)this, intent);
                break;
            }
            case "org.infobip.mobile.messaging.gcm.token.cleanup": {
                this.registrationTokenHandler.handleRegistrationTokenCleanup((Context)this, intent.getStringExtra(EXTRA_GCM_SENDER_ID));
                break;
            }
            case "org.infobip.mobile.messaging.gcm.INSTANCE_ID": {
                this.registrationTokenHandler.handleRegistrationTokenUpdate((Context)this);
            }
        }
    }
}

