/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.data;

import android.content.Context;
import android.os.AsyncTask;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.SystemData;
import org.infobip.mobile.messaging.api.data.SystemDataReport;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobile.InternalSdkError;
import org.infobip.mobile.messaging.mobile.MobileApiResourceProvider;
import org.infobip.mobile.messaging.mobile.data.SystemDataReportResult;
import org.infobip.mobile.messaging.util.StringUtils;

class SystemDataReportTask
extends AsyncTask<SystemDataReport, Void, SystemDataReportResult> {
    private final Context context;

    SystemDataReportTask(Context context) {
        this.context = context;
    }

    protected SystemDataReportResult doInBackground(SystemDataReport ... params) {
        if (params.length < 1) {
            MobileMessagingLogger.e(InternalSdkError.ERROR_EMPTY_SYSTEM_DATA.get());
            return new SystemDataReportResult(InternalSdkError.ERROR_EMPTY_SYSTEM_DATA.getException());
        }
        SystemDataReport report = params[0];
        SystemData data = new SystemData(report.getSdkVersion(), report.getOsVersion(), report.getDeviceManufacturer(), report.getDeviceModel(), report.getApplicationVersion(), report.getGeofencing(), report.getNotificationsEnabled(), report.getDeviceSecure());
        MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance(this.context);
        if (StringUtils.isBlank(mobileMessagingCore.getDeviceApplicationInstanceId())) {
            MobileMessagingLogger.w("Can't report system data without valid registration");
            return new SystemDataReportResult(data, true);
        }
        try {
            MobileMessagingLogger.v("SYSTEM DATA >>>", report);
            MobileApiResourceProvider.INSTANCE.getMobileApiData(this.context).reportSystemData(report);
            MobileMessagingLogger.v("SYSTEM DATA <<<");
            return new SystemDataReportResult(data);
        }
        catch (Exception e) {
            mobileMessagingCore.setLastHttpException(e);
            MobileMessagingLogger.e("Error reporting system data!", e);
            this.cancel(true);
            return new SystemDataReportResult(e);
        }
    }
}

