/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.data;

import android.content.Context;
import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.SystemData;
import org.infobip.mobile.messaging.api.data.SystemDataReport;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobile.MobileMessagingError;
import org.infobip.mobile.messaging.mobile.data.SystemDataReportResult;
import org.infobip.mobile.messaging.mobile.data.SystemDataReportTask;
import org.infobip.mobile.messaging.mobile.synchronizer.RetryableSynchronizer;
import org.infobip.mobile.messaging.mobile.synchronizer.Task;
import org.infobip.mobile.messaging.platform.Broadcaster;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.stats.MobileMessagingStatsError;

public class SystemDataReporter
extends RetryableSynchronizer {
    private Broadcaster broadcaster;

    public SystemDataReporter(Context context, MobileMessagingStats stats, Executor executor, Broadcaster broadcaster) {
        super(context, stats, executor);
        this.broadcaster = broadcaster;
    }

    @Override
    public void synchronize() {
        SystemData data = MobileMessagingCore.getInstance(this.context).getUnreportedSystemData();
        if (data == null) {
            return;
        }
        SystemDataReport report = new SystemDataReport(data.getSdkVersion(), data.getOsVersion(), data.getDeviceManufacturer(), data.getDeviceModel(), data.getApplicationVersion(), Boolean.valueOf(data.isGeofencing()), Boolean.valueOf(data.areNotificationsEnabled()), Boolean.valueOf(data.isDeviceSecure()));
        new SystemDataReportTask(this.context){

            protected void onPostExecute(SystemDataReportResult result) {
                if (result.hasError()) {
                    MobileMessagingLogger.e("MobileMessaging API returned error (system data)!");
                    SystemDataReporter.this.stats.reportError(MobileMessagingStatsError.SYSTEM_DATA_REPORT_ERROR);
                    SystemDataReporter.this.broadcaster.error(MobileMessagingError.createFrom(result.getError()));
                    SystemDataReporter.this.retry(result);
                    return;
                }
                if (result.isPostponed()) {
                    MobileMessagingLogger.w("System data report is saved and will be sent at a later time");
                    return;
                }
                MobileMessagingCore.getInstance(SystemDataReporter.this.context).setSystemDataReported();
                SystemDataReporter.this.broadcaster.systemDataReported(result.getData());
            }

            protected void onCancelled(SystemDataReportResult result) {
                MobileMessagingLogger.e("Error reporting user data!");
                SystemDataReporter.this.stats.reportError(MobileMessagingStatsError.SYSTEM_DATA_REPORT_ERROR);
                SystemDataReporter.this.broadcaster.error(MobileMessagingError.createFrom(result.getError()));
                SystemDataReporter.this.retry(result);
            }
        }.executeOnExecutor(this.executor, new SystemDataReport[]{report});
    }

    @Override
    public Task getTask() {
        return Task.SYSTEM_DATA_REPORT;
    }
}

